/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jelly;

import com.sun.script.jelly.ScriptExpressionFactory;
import com.sun.script.jelly.ScriptTag;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.tags.core.CoreTagLibrary;
import org.xml.sax.Attributes;

public class ScriptTagLibrary
extends CoreTagLibrary {
    private static final String DEFAULT_LANGUAGE = "JavaScript";
    private ScriptExpressionFactory expressionFactory;
    private ScriptEngineManager manager = new ScriptEngineManager();
    private Map<String, ScriptEngine> engines;

    public ScriptTagLibrary() {
        this.expressionFactory = new ScriptExpressionFactory(this);
        this.engines = new HashMap<String, ScriptEngine>();
        this.registerTagFactory("script", new TagFactory(){

            public Tag createTag(String name, Attributes attributes) throws JellyException {
                return ScriptTagLibrary.this.createScriptTag(name, attributes);
            }
        });
    }

    ScriptEngine getDefaultScriptEngine() {
        return this.getScriptEngine(DEFAULT_LANGUAGE);
    }

    private synchronized ScriptEngine getScriptEngine(String lang) {
        ScriptEngine e = this.engines.get(lang);
        if (e == null) {
            e = this.manager.getEngineByName(lang);
            this.engines.put(lang, e);
        }
        return e;
    }

    protected ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    protected Tag createScriptTag(String name, Attributes attributes) throws JellyException {
        ScriptEngine engine;
        String lang = attributes.getValue("", "language");
        if (lang == null || lang.equals("")) {
            lang = DEFAULT_LANGUAGE;
        }
        if ((engine = this.getScriptEngine(lang)) == null) {
            throw new JellyException("language " + lang + " not yet supported");
        }
        return new ScriptTag(engine);
    }
}

