/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsReporter;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.EndpointView;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public abstract class AbstractEndpoint
extends FaultHandler
implements Endpoint,
PropertyInclude {
    protected Log log;
    protected static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String endpointName = null;
    private String description = null;
    private Endpoint parentEndpoint = null;
    private List<Endpoint> children = null;
    private EndpointDefinition definition = null;
    protected boolean initialized = false;
    private EndpointContext context = null;
    protected Boolean isClusteringEnabled = null;
    EndpointView metricsMBean = null;
    protected String fileName;
    private Map<String, MediatorProperty> properties = new HashMap<String, MediatorProperty>();
    protected boolean anonymous = false;
    protected String errorHandler = null;
    private boolean enableMBeanStats = true;
    private boolean contentAware = false;

    protected AbstractEndpoint() {
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public EndpointView getMetricsMBean() {
        return this.metricsMBean;
    }

    @Override
    public EndpointContext getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.endpointName;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public EndpointDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(EndpointDefinition definition) {
        this.definition = definition;
        definition.setLeafEndpoint(this);
    }

    public Endpoint getParentEndpoint() {
        return this.parentEndpoint;
    }

    @Override
    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    @Override
    public List<Endpoint> getChildren() {
        return this.children;
    }

    public void setChildren(List<Endpoint> children) {
        this.children = children;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        if (this.endpointName != null) {
            return "Endpoint [" + this.endpointName + "]";
        }
        return "AnonymousEndpoint";
    }

    @Override
    public void setName(String endpointName) {
        this.endpointName = endpointName;
        if (this.enableMBeanStats) {
            if (endpointName == null || "".equals(endpointName.trim())) {
                this.log.warn((Object)"Endpoint Name not found. Skipped JMX statistics collection for this endpoint");
                return;
            }
            this.metricsMBean = new EndpointView(endpointName, this);
            MBeanRegistrar.getInstance().registerMBean((Object)this.metricsMBean, "Endpoint", endpointName);
        }
    }

    public void setEnableMBeanStats(boolean flag) {
        this.enableMBeanStats = flag;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            ClusteringAgent clusteringAgent = cc.getAxisConfiguration().getClusteringAgent();
            this.isClusteringEnabled = clusteringAgent != null && clusteringAgent.getStateManager() != null ? Boolean.TRUE : Boolean.FALSE;
            this.context = new EndpointContext(this.getName(), this.getDefinition(), this.isClusteringEnabled, cc, this.metricsMBean);
        }
        this.initialized = true;
        if (this.children != null) {
            for (Endpoint e : this.children) {
                e.init(synapseEnvironment);
            }
        }
        this.contentAware = this.definition != null && (this.definition.getFormat() != null && !this.definition.getFormat().equals("rest") || this.definition.isSecurityOn() || this.definition.isAddressingOn());
    }

    @Override
    public boolean readyToSend() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized, endpoint must be in initialized state");
        }
        return this.context != null && this.context.readyToSend();
    }

    @Override
    public void send(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (!this.initialized) {
            throw new IllegalStateException("not initialized, endpoint must be in initialized state");
        }
        this.prepareForEndpointStatistics(synCtx);
        if (traceOrDebugOn) {
            String address = this.definition.getAddress();
            if (address == null && synCtx.getTo() != null && synCtx.getTo().getAddress() != null) {
                address = synCtx.getTo().getAddress();
            }
            this.traceOrDebug(traceOn, "Sending message through endpoint : " + this.getName() + " resolving to address = " + address);
            this.traceOrDebug(traceOn, "SOAPAction: " + (synCtx.getSoapAction() != null ? synCtx.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Envelope : \n" + synCtx.getEnvelope()));
            }
        }
        if (this.errorHandler != null) {
            Mediator errorHandlerMediator = synCtx.getSequence(this.errorHandler);
            if (errorHandlerMediator != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Setting the onError handler : " + this.errorHandler + " for the endpoint : " + this.endpointName);
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
            } else {
                this.log.warn((Object)("onError handler sequence : " + this.errorHandler + " for : " + this.endpointName + " cannot be found"));
            }
        }
        synCtx.pushFaultHandler(this);
        synCtx.setProperty("last_endpoint", this);
        org.apache.axis2.context.MessageContext axis2Ctx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        axis2Ctx.setProperty("METRICS_COLLECTOR", (Object)this.metricsMBean);
        if (this.contentAware) {
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
                axis2Ctx.setProperty("FORCE_RESPONSE_EARLY_BUILD", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                this.handleException("Error while building message", e);
            }
        }
        this.evaluateProperties(synCtx);
        MediatorProperty preserveEnv = this.getProperty("PRESERVE_ENVELOPE");
        if (preserveEnv != null && JavaUtils.isTrueExplicitly((String)(preserveEnv.getValue() != null ? preserveEnv.getValue() : preserveEnv.getEvaluatedExpression(synCtx)))) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Preserving the envelope by building it before sending, since it is explicitly set");
            }
            synCtx.getEnvelope().build();
        }
        synCtx.getEnvironment().send(this.definition, synCtx);
    }

    public boolean isLeafEndpoint() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
    }

    protected boolean isTimeout(MessageContext synCtx) {
        Integer errorCode = (Integer)synCtx.getProperty("ERROR_CODE");
        if (errorCode != null) {
            if (this.definition.getTimeoutErrorCodes().isEmpty()) {
                boolean isClosed;
                boolean isTimeout = 101504 == errorCode;
                boolean bl = isClosed = 101505 == errorCode;
                if (isTimeout || isClosed) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Encountered a default HTTP connection " + (isClosed ? "close" : "timeout") + " error : " + errorCode));
                    }
                    return true;
                }
            } else if (this.definition.getTimeoutErrorCodes().contains(errorCode)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Encountered a mark for suspension error : " + errorCode + " defined error codes are : " + this.definition.getTimeoutErrorCodes()));
                }
                return true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered a non-timeout error sending to " + this.toString() + ", error code : " + errorCode));
        }
        return false;
    }

    protected boolean isRetryDisabled(MessageContext synCtx) {
        Integer errorCode = (Integer)synCtx.getProperty("ERROR_CODE");
        if (errorCode != null && this.definition != null && this.definition.getRetryDisabledErrorCodes().contains(errorCode)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Encountered a retry disabled error : " + errorCode + ", defined retry disabled error codes are : " + this.definition.getRetryDisabledErrorCodes()));
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered an error sending to endpoint : " + this.endpointName + ", with error code : " + errorCode + ", but not a retry disabled error"));
        }
        return false;
    }

    protected boolean isSuspendFault(MessageContext synCtx) {
        Integer errorCode = (Integer)synCtx.getProperty("ERROR_CODE");
        if (errorCode != null) {
            if (this.definition.getSuspendErrorCodes().isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.toString() + " encountered a fatal error : " + errorCode));
                }
                return true;
            }
            if (this.definition.getSuspendErrorCodes().contains(errorCode)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Encountered a suspend error : " + errorCode + " defined suspend codes are : " + this.definition.getSuspendErrorCodes()));
                }
                return true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered a non-fatal error sending to " + this.toString() + ", error code : " + errorCode + ". Error will be handled, but endpoint will not fail"));
        }
        return false;
    }

    @Override
    public void onFault(MessageContext synCtx) {
        this.invokeNextFaultHandler(synCtx);
    }

    @Override
    public void onSuccess() {
    }

    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.definition != null && (this.definition.getTraceState() == 1 || this.definition.getTraceState() == 2 && msgCtx.getTracingState() == 1);
    }

    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || this.log.isDebugEnabled();
    }

    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }

    protected void prepareForEndpointStatistics(MessageContext synCtx) {
        if (this.definition != null && this.definition.isStatisticsEnable()) {
            String opName = null;
            if (synCtx.getProperty("endpoint.operation") != null) {
                opName = synCtx.getProperty("endpoint.operation").toString();
            } else if (synCtx instanceof Axis2MessageContext) {
                AxisOperation operation = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getAxisOperation();
                if (operation != null) {
                    opName = operation.getName().getLocalPart();
                }
                if (opName == null || SynapseConstants.SYNAPSE_OPERATION_NAME.getLocalPart().equals(opName)) {
                    String soapAction = synCtx.getSoapAction();
                    opName = null;
                    if (soapAction != null) {
                        int index = soapAction.indexOf("urn:");
                        opName = index >= 0 ? soapAction.substring("urn:".length()) : soapAction;
                    }
                }
            }
            AspectConfiguration oldConfiguration = this.definition.getAspectConfiguration();
            if (opName != null) {
                if (oldConfiguration.isStatisticsEnable()) {
                    AspectConfiguration newConfiguration = new AspectConfiguration(oldConfiguration.getId() + "__" + opName);
                    newConfiguration.enableStatistics();
                    StatisticsReporter.reportForComponent(synCtx, newConfiguration, ComponentType.ENDPOINT);
                }
            } else {
                StatisticsReporter.reportForComponent(synCtx, oldConfiguration, ComponentType.ENDPOINT);
            }
        }
    }

    protected void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    protected void logOnChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.log.warn((Object)(this + " Detect a Failure in a child endpoint : " + endpoint));
    }

    protected void informFailure(MessageContext synCtx, int errorCode, String errorMsg) {
        this.log.warn((Object)("Endpoint failure - Error Code: " + errorCode + ", Error Message: " + errorMsg));
        if (synCtx.getProperty("last_endpoint") == null || synCtx.getProperty("ERROR_CODE") == null) {
            this.setErrorOnMessage(synCtx, String.valueOf(errorCode), errorMsg);
        }
        this.invokeNextFaultHandler(synCtx);
    }

    protected void setErrorOnMessage(MessageContext synCtx, String errorCode, String errorMsg) {
        synCtx.setProperty("ERROR_CODE", errorCode);
        synCtx.setProperty("ERROR_MESSAGE", errorMsg);
        synCtx.setProperty("ERROR_DETAIL", errorMsg);
    }

    private void invokeNextFaultHandler(MessageContext synCtx) {
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (!faultStack.isEmpty()) {
            FaultHandler faultHandler = faultStack.pop();
            if (faultHandler instanceof Endpoint) {
                ((Endpoint)((Object)faultHandler)).onChildEndpointFail(this, synCtx);
            } else {
                faultHandler.handleFault(synCtx);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.metricsMBean != null) {
            this.metricsMBean.destroy();
        }
        if (this.enableMBeanStats) {
            MBeanRegistrar.getInstance().unRegisterMBean("Endpoint", this.endpointName);
        }
        this.metricsMBean = null;
        this.initialized = false;
    }

    @Override
    public void addProperty(MediatorProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public MediatorProperty getProperty(String name) {
        MediatorProperty value = this.properties.get(name);
        if (value == null && this.getParentEndpoint() instanceof PropertyInclude) {
            value = ((PropertyInclude)((Object)this.getParentEndpoint())).getProperty(name);
        }
        return value;
    }

    @Override
    public Collection<MediatorProperty> getProperties() {
        return this.properties.values();
    }

    @Override
    public MediatorProperty removeProperty(String name) {
        return this.properties.remove(name);
    }

    @Override
    public void addProperties(Collection<MediatorProperty> mediatorProperties) {
        for (MediatorProperty property : mediatorProperties) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public String getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void evaluateProperties(MessageContext synCtx) {
        Set<Map.Entry<String, MediatorProperty>> propertySet = this.properties.entrySet();
        for (Map.Entry<String, MediatorProperty> e : propertySet) {
            e.getValue().evaluate(synCtx);
        }
    }
}

