/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;

public class DefaultEndpointFactory
extends EndpointFactory {
    private static DefaultEndpointFactory instance = new DefaultEndpointFactory();

    protected DefaultEndpointFactory() {
    }

    public static DefaultEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement defaultElement;
        DefaultEndpoint defaultEndpoint = new DefaultEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            defaultEndpoint.setName(name.getAttributeValue());
        }
        if ((defaultElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "default"))) != null) {
            EndpointDefinition endpoint = this.createEndpointDefinition(defaultElement);
            defaultEndpoint.setDefinition(endpoint);
            this.processAuditStatus(endpoint, defaultEndpoint.getName(), defaultElement);
        }
        this.processProperties(defaultEndpoint, epConfig);
        return defaultEndpoint;
    }

    @Override
    protected void extractSpecificEndpointProperties(EndpointDefinition definition, OMElement elem) {
        OMAttribute format = elem.getAttribute(new QName("", "format"));
        if (format != null) {
            String forceValue = format.getAttributeValue().trim().toLowerCase();
            if ("pox".equals(forceValue)) {
                definition.setForcePOX(true);
                definition.setFormat("pox");
            } else if ("get".equals(forceValue)) {
                definition.setForceGET(true);
                definition.setFormat("get");
            } else if ("soap11".equals(forceValue)) {
                definition.setForceSOAP11(true);
                definition.setFormat("soap11");
            } else if ("soap12".equals(forceValue)) {
                definition.setForceSOAP12(true);
                definition.setFormat("soap12");
            } else if ("rest".equals(forceValue)) {
                definition.setForceREST(true);
                definition.setFormat("rest");
            }
        }
    }

    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        EndpointDefinition endpointDefinition;
        DefinitionFactory fac = this.getEndpointDefinitionFactory();
        if (fac == null) {
            fac = new EndpointDefinitionFactory();
            endpointDefinition = fac.createDefinition(elem);
        } else {
            endpointDefinition = fac.createDefinition(elem);
        }
        this.extractSpecificEndpointProperties(endpointDefinition, elem);
        return endpointDefinition;
    }

    protected void processAuditStatus(EndpointDefinition definition, String name, OMElement epOmElement) {
        String statisticsValue;
        if (name == null || "".equals(name)) {
            name = "AnonymousEndpoint";
        }
        AspectConfiguration aspectConfiguration = new AspectConfiguration(name);
        definition.configure(aspectConfiguration);
        OMAttribute statistics = epOmElement.getAttribute(new QName("statistics"));
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null && "enable".equals(statisticsValue)) {
            aspectConfiguration.enableStatistics();
        }
    }
}

