/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.config.xml.TemplateParameterSerializer;
import org.apache.synapse.mediators.TemplateParameter;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateMediatorSerializer
extends AbstractListMediatorSerializer {
    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof TemplateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
            return null;
        }
        TemplateMediator mediator = (TemplateMediator)m;
        OMElement templateElem = fac.createOMElement("template", synNS);
        if (mediator.getName() != null) {
            templateElem.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            this.serializeParams(templateElem, mediator);
            this.serializeBody(templateElem, mediator.getList());
            TemplateMediatorSerializer.saveTracingState(templateElem, mediator);
        }
        return templateElem;
    }

    private void serializeParams(OMElement templateElem, TemplateMediator mediator) {
        Collection<TemplateParameter> params = mediator.getParameters();
        if (params != null && params.size() > 0) {
            TemplateParameterSerializer.serializeTemplateParameters(templateElem, mediator.getParameters());
        }
    }

    private void serializeBody(OMElement templateElem, List<Mediator> childMediatorList) {
        OMElement seqEl = fac.createOMElement("sequence", synNS);
        templateElem.addChild((OMNode)seqEl);
        this.serializeChildren(seqEl, childMediatorList);
    }

    @Override
    public String getMediatorClassName() {
        return TemplateMediator.class.getName();
    }
}

