/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.wsdl.SchemaReaderException;
import org.apache.axis2.jaxws.wsdl.impl.SchemaReaderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageSetBuilder {
    private static Log log = LogFactory.getLog(PackageSetBuilder.class);
    private static final Class[] noClass = new Class[0];

    private PackageSetBuilder() {
    }

    public static TreeSet<String> getPackagesFromSchema(ServiceDescription serviceDesc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getPackagesFromSchema");
            log.debug((Object)("ServiceDescription = " + serviceDesc.toString()));
        }
        TreeSet<String> set = new TreeSet<String>();
        ServiceDescriptionWSDL sdw = (ServiceDescriptionWSDL)serviceDesc;
        Definition wsdlDefinition = sdw.getWSDLDefinition();
        Collection endpointDescs = serviceDesc.getEndpointDescriptions_AsCollection();
        if (endpointDescs != null) {
            for (EndpointDescription ed : endpointDescs) {
                if (wsdlDefinition == null && ed instanceof EndpointDescriptionJava) {
                    String wsdlLocation = ((EndpointDescriptionJava)ed).getAnnoWebServiceWSDLLocation();
                    wsdlDefinition = PackageSetBuilder.getWSDLDefinition(wsdlLocation);
                }
                if (wsdlDefinition == null) continue;
                SchemaReaderImpl sr = new SchemaReaderImpl();
                try {
                    Set<String> pkgSet = sr.readPackagesFromSchema(wsdlDefinition);
                    set.addAll(pkgSet);
                }
                catch (SchemaReaderException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end getPackagesFromSchema");
        }
        return set;
    }

    public static TreeSet<String> getPackagesFromAnnotations(ServiceDescription serviceDesc, MarshalServiceRuntimeDescription msrd) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getPackagesFromAnnotations");
            log.debug((Object)("ServiceDescription = " + serviceDesc.toString()));
            log.debug((Object)("MarshalServiceRuntimeDescription = " + msrd.toString()));
        }
        TreeSet<String> set = new TreeSet<String>();
        Collection endpointDescs = serviceDesc.getEndpointDescriptions_AsCollection();
        if (endpointDescs != null) {
            for (EndpointDescription endpointDesc : endpointDescs) {
                set.addAll(PackageSetBuilder.getPackagesFromAnnotations(endpointDesc, msrd));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end getPackagesFromAnnotations");
        }
        return set;
    }

    private static TreeSet<String> getPackagesFromAnnotations(EndpointDescription endpointDesc, MarshalServiceRuntimeDescription msrd) {
        EndpointInterfaceDescription endpointInterfaceDesc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("start getPackagesFromAnnotations for EndpointDescription " + endpointDesc.getName()));
        }
        TreeSet<String> set = new TreeSet<String>();
        String implClassName = PackageSetBuilder.getServiceImplClassName(endpointDesc);
        if (implClassName != null) {
            Class clz;
            if (log.isDebugEnabled()) {
                log.debug((Object)("EndpointDescription implClassName = " + implClassName));
            }
            if ((clz = PackageSetBuilder.loadClass(implClassName)) == null) {
                clz = PackageSetBuilder.loadClass(implClassName, endpointDesc.getAxisService().getClassLoader());
            }
            if (clz != null) {
                PackageSetBuilder.addXmlSeeAlsoPackages(clz, msrd, set);
            }
        }
        if ((endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription()) != null) {
            PackageSetBuilder.getPackagesFromAnnotations(endpointDesc, endpointInterfaceDesc, set, msrd);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end getPackagesFromAnnotations for EndpointDescription " + endpointDesc.getName()));
        }
        return set;
    }

    private static void getPackagesFromAnnotations(EndpointDescription ed, EndpointInterfaceDescription endpointInterfaceDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        String implClassName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("start getPackagesFromAnnotations for EndpointInterfaceDescription " + endpointInterfaceDesc.getPortType()));
        }
        OperationDescription[] opDescs = endpointInterfaceDesc.getDispatchableOperations();
        Class seicls = endpointInterfaceDesc.getSEIClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SEI Class is " + seicls));
        }
        if (seicls == null && (implClassName = PackageSetBuilder.getServiceImplClassName(ed)) != null) {
            WebService ws;
            Class clz;
            if (log.isDebugEnabled()) {
                log.debug((Object)("EndpointDescription implClassName = " + implClassName));
            }
            if ((clz = PackageSetBuilder.loadClass(implClassName)) == null) {
                clz = PackageSetBuilder.loadClass(implClassName, ed.getAxisService().getClassLoader());
            }
            if (clz != null && (ws = (WebService)PackageSetBuilder.getAnnotation(clz, WebService.class)) != null) {
                String intClassName = ws.endpointInterface();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WebService endpointinterface = " + intClassName));
                }
                if ((seicls = PackageSetBuilder.loadClass(intClassName)) == null) {
                    seicls = PackageSetBuilder.loadClass(intClassName, ed.getAxisService().getClassLoader());
                }
            }
        }
        PackageSetBuilder.addXmlSeeAlsoPackages(seicls, msrd, set);
        if (opDescs != null) {
            for (int i = 0; i < opDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(ed, opDescs[i], set, msrd);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end getPackagesFromAnnotations for EndpointInterfaceDescription " + endpointInterfaceDesc.getPortType()));
        }
    }

    private static void getPackagesFromAnnotations(EndpointDescription ed, OperationDescription opDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        Class cls;
        List packages;
        String ns;
        FaultDescription[] faultDescs;
        ParameterDescription[] parameterDescs = opDesc.getParameterDescriptions();
        if (parameterDescs != null) {
            for (int i = 0; i < parameterDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(parameterDescs[i], set, msrd);
            }
        }
        if ((faultDescs = opDesc.getFaultDescriptions()) != null) {
            for (int i = 0; i < faultDescs.length; ++i) {
                PackageSetBuilder.getPackagesFromAnnotations(ed, faultDescs[i], set, msrd);
            }
        }
        String requestWrapperName = msrd.getRequestWrapperClassName(opDesc);
        String requestWrapperPkg = PackageSetBuilder.getPackageFromClassName(requestWrapperName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Package from Request Wrapper annotation = " + requestWrapperPkg));
        }
        if (requestWrapperPkg != null) {
            set.add(requestWrapperPkg);
            set.add("@" + requestWrapperPkg);
            set.add("[" + requestWrapperName + "]");
        }
        String responseWrapperName = msrd.getResponseWrapperClassName(opDesc);
        String responseWrapperPkg = PackageSetBuilder.getPackageFromClassName(responseWrapperName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Package from Response Wrapper annotation = " + responseWrapperPkg));
        }
        if (responseWrapperPkg != null) {
            set.add(responseWrapperPkg);
            set.add("@" + responseWrapperPkg);
            set.add("[" + responseWrapperName + "]");
        }
        if ((ns = opDesc.getRequestWrapperTargetNamespace()) != null && ns.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("TargetNamespace from Request Wrapper annotation = " + ns));
            }
            packages = PackageSetBuilder.makePackages(ns);
            set.addAll(packages);
        }
        if ((ns = opDesc.getResponseWrapperTargetNamespace()) != null && ns.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("TargetNamespace from Response Wrapper annotation = " + ns));
            }
            packages = PackageSetBuilder.makePackages(ns);
            set.addAll(packages);
        }
        Method m = PackageSetBuilder.getMethod(opDesc, msrd);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method obtained:" + m));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Collect the packages of the parameters");
        }
        PackageSetBuilder.addPackagesFromParameters(set, opDesc);
        if (m != null) {
            PackageSetBuilder.addPackagesFromParameters(set, m);
        }
        if ((cls = opDesc.getResultActualType()) != null && cls != Void.TYPE && cls != Void.class) {
            String pkg = PackageSetBuilder.getPackageFromClass(cls);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Package from Return Type = " + pkg));
            }
            if (pkg != null) {
                set.add(pkg);
                set.add("@" + pkg);
                set.add("[" + cls.getCanonicalName() + "]");
            }
            if (m != null) {
                PackageSetBuilder.addPackagesFromReturn(set, m);
            }
        }
    }

    private static Method getMethod(OperationDescription opDesc, MarshalServiceRuntimeDescription msrd) {
        Method m;
        block2: {
            m = null;
            try {
                m = msrd.getMethod(opDesc);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Method could not be obtained due to " + t));
            }
        }
        return m;
    }

    private static void addPackagesFromParameters(TreeSet<String> set, Method m) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("enter addPackagesFromParameters for " + m));
            }
            try {
                if (m != null) {
                    Set<Class> classes = new HashSet<Class>();
                    for (Type type : m.getGenericParameterTypes()) {
                        classes = ClassUtils.getClasses(type, classes);
                    }
                    PackageSetBuilder.addClassesToPackageSet(classes, set);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Could not reflect the information on method " + m + " due to " + t));
                log.debug((Object)"Processing continues");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"exit addPackagesFromParameters");
        }
    }

    private static void addPackagesFromReturn(TreeSet<String> set, Method m) {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("enter addPackagesFromReturn for " + m));
            }
            try {
                if (m != null) {
                    Set<Class> classes = new HashSet<Class>();
                    classes = ClassUtils.getClasses(m.getGenericReturnType(), classes);
                    PackageSetBuilder.addClassesToPackageSet(classes, set);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Could not reflect the information on method " + m + " due to " + t));
                log.debug((Object)"Processing continues");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"exit addPackagesFromReturn");
        }
    }

    private static void addClassesToPackageSet(Set<Class> classSet, TreeSet<String> set) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"enter addClassesToPackageSet");
        }
        if (classSet != null) {
            for (Class clz : classSet) {
                String pkgText;
                if (clz == null || clz == Holder.class || clz == Future.class || clz == Response.class) continue;
                Package pkg = clz.getPackage();
                String string = pkgText = pkg != null ? pkg.getName() : null;
                if (pkg == null) continue;
                String name = clz.getCanonicalName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" adding class " + name));
                }
                set.add("@" + pkgText);
                set.add("[" + name + "]");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"exit addClassesToPackageSet");
        }
    }

    private static void addPackagesFromParameters(TreeSet<String> set, OperationDescription opDesc) {
        ParameterDescription[] pDescs = opDesc.getParameterDescriptions();
        if (pDescs != null) {
            for (int i = 0; i < pDescs.length; ++i) {
                ParameterDescription pDesc = pDescs[i];
                if (pDesc == null) continue;
                Class paramClass = pDesc.getParameterActualType();
                String pkg = PackageSetBuilder.getPackageFromClass(paramClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Package from Parameter (" + paramClass + ") = " + pkg));
                }
                if (pkg == null) continue;
                set.add(pkg);
                set.add("@" + pkg);
                set.add("[" + paramClass.getCanonicalName() + "]");
            }
        }
    }

    private static void getPackagesFromAnnotations(ParameterDescription paramDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        Class paramClass = paramDesc.getParameterActualType();
        if (paramClass != null) {
            PackageSetBuilder.setTypeAndElementPackages(paramClass, paramDesc.getTargetNamespace(), paramDesc.getPartName(), set, msrd);
        }
    }

    private static void getPackagesFromAnnotations(EndpointDescription ed, FaultDescription faultDesc, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        FaultBeanDesc faultBeanDesc = msrd.getFaultBeanDesc(faultDesc);
        if (faultBeanDesc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"faultBeanDesc from MarshallServiceRuntimeDescription is null");
            }
            return;
        }
        String faultBeanName = faultBeanDesc.getFaultBeanClassName();
        if (faultBeanName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"FaultBeanName is null");
            }
            return;
        }
        Class faultBean = PackageSetBuilder.loadClass(faultBeanName);
        if (faultBean == null) {
            faultBean = PackageSetBuilder.loadClass(faultBeanName, ed.getAxisService().getClassLoader());
        }
        if (faultBean != null) {
            PackageSetBuilder.setTypeAndElementPackages(faultBean, faultBeanDesc.getFaultBeanNamespace(), faultBeanDesc.getFaultBeanLocalName(), set, msrd);
        }
    }

    private static void setTypeAndElementPackages(Class cls, String namespace, String localPart, TreeSet<String> set, MarshalServiceRuntimeDescription msrd) {
        String override;
        String pkg2;
        int i;
        List pkgs;
        String ns;
        AnnotationDesc ad;
        String pkg;
        Class eClass = PackageSetBuilder.getElement(cls, msrd);
        Class tClass = PackageSetBuilder.getType(cls);
        if (tClass != null) {
            Package typePkg = tClass.getPackage();
            String string = pkg = typePkg != null ? typePkg.getName() : null;
            if (pkg != null) {
                set.add(pkg);
                set.add("@" + pkg);
                set.add("[" + tClass.getCanonicalName() + "]");
            }
            if (pkg != null && (ad = msrd.getAnnotationDesc(tClass)) != null && ad.hasXmlType() && (ns = ad.getXmlTypeNamespace()) != null && ns.length() > 0 && (pkgs = PackageSetBuilder.makePackages(ns)) != null) {
                for (i = 0; i < pkgs.size(); ++i) {
                    pkg2 = (String)pkgs.get(i);
                    if (pkg.equals(pkg2) || set.contains(override = pkg + " > " + pkg2)) continue;
                    set.add(override);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding override=" + override));
                }
            }
            PackageSetBuilder.addXmlSeeAlsoPackages(tClass, msrd, set);
        }
        if (tClass != eClass) {
            if (eClass == null) {
                List pkgs2;
                if (namespace != null && namespace.length() > 0 && (pkgs2 = PackageSetBuilder.makePackages(namespace)) != null) {
                    set.addAll(pkgs2);
                }
            } else {
                Package elementPkg = eClass.getPackage();
                String string = pkg = elementPkg != null ? elementPkg.getName() : null;
                if (pkg != null) {
                    set.add(pkg);
                    set.add("@" + pkg);
                    set.add("[" + eClass.getCanonicalName() + "]");
                }
                if (pkg != null && (ad = msrd.getAnnotationDesc(tClass)) != null && ad.hasXmlRootElement() && (ns = ad.getXmlRootElementNamespace()) != null && ns.length() > 0 && (pkgs = PackageSetBuilder.makePackages(ns)) != null) {
                    for (i = 0; i < pkgs.size(); ++i) {
                        pkg2 = (String)pkgs.get(i);
                        if (pkg.equals(pkg2) || set.contains(override = pkg + " > " + pkg2)) continue;
                        set.add(override);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Adding override=" + override));
                    }
                }
                PackageSetBuilder.addXmlSeeAlsoPackages(tClass, msrd, set);
            }
        }
    }

    private static Class getElement(Class cls, MarshalServiceRuntimeDescription msrd) {
        AnnotationDesc annotationDesc = msrd.getAnnotationDesc(cls);
        if (annotationDesc == null) {
            annotationDesc = AnnotationDescImpl.create(cls);
        }
        if (annotationDesc.hasXmlRootElement()) {
            return cls;
        }
        return null;
    }

    private static Class getType(Class cls) {
        if (JAXBElement.class.isAssignableFrom(cls)) {
            try {
                Method m = cls.getMethod("getValue", noClass);
                return m.getReturnType();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot find JAXBElement.getValue method.");
                }
                return null;
            }
        }
        return cls;
    }

    private static List makePackages(String ns) {
        List packages = JavaUtils.getPackagesFromNamespace(ns);
        return packages;
    }

    public static String getPackageFromClassName(String className) {
        Class clz = PackageSetBuilder.loadClass(className);
        String pkg = PackageSetBuilder.getPackageFromClass(clz);
        return pkg;
    }

    public static String getPackageFromClass(Class cls) {
        Object pkgName = null;
        pkgName = cls == null ? null : (cls.isArray() ? PackageSetBuilder.getPackageFromClass(cls.getComponentType()) : (cls.isPrimitive() ? null : (cls.getPackage() == null ? "" : cls.getPackage().getName())));
        return pkgName;
    }

    private static void addXmlSeeAlsoPackages(Class clz, MarshalServiceRuntimeDescription msrd, TreeSet<String> set) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start addXmlSeeAlsoPackages for " + clz));
        }
        if (clz != null) {
            Class<?>[] interfaces;
            int i;
            Class[] seeAlso;
            AnnotationDesc aDesc = msrd.getAnnotationDesc(clz);
            if (aDesc != null && (seeAlso = aDesc.getXmlSeeAlsoClasses()) != null) {
                for (i = 0; i < seeAlso.length; ++i) {
                    String pkg;
                    String string = seeAlso[i] == null ? null : (pkg = seeAlso[i].getPackage() == null ? "" : seeAlso[i].getPackage().getName());
                    if (pkg == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" adding package = " + pkg));
                    }
                    set.add(pkg);
                    set.add("@" + pkg);
                    set.add("[" + seeAlso[i].getCanonicalName() + "]");
                }
            }
            if ((interfaces = clz.getInterfaces()) != null) {
                for (i = 0; i < interfaces.length; ++i) {
                    PackageSetBuilder.addXmlSeeAlsoPackages(interfaces[i], msrd, set);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end addXmlSeeAlsoPackages for " + clz));
        }
    }

    private static Class loadClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class<?> cls = ClassUtils.getPrimitiveClass(className);
            if (cls == null) {
                cls = Class.forName(className, true, PackageSetBuilder.getContextClassLoader());
            }
            return cls;
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PackageSetBuilder cannot load the following class:" + className));
            }
            return null;
        }
    }

    private static Class loadClass(String className, ClassLoader loader) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class cls = ClassUtils.getPrimitiveClass(className);
            if (cls == null) {
                cls = PackageSetBuilder.forName(className, true, loader);
            }
            return cls;
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PackageSetBuilder cannot load the following class:" + className));
            }
            return null;
        }
    }

    private static Definition getWSDLDefinition(String wsdlLoc) {
        Definition wsdlDefinition;
        block3: {
            wsdlDefinition = null;
            final String wsdlLocation = wsdlLoc;
            if (wsdlLocation != null && wsdlLocation.trim().length() > 0) {
                try {
                    wsdlDefinition = (Definition)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws MalformedURLException, IOException, WSDLException {
                            String baseDir = new File(System.getProperty("basedir", ".")).getCanonicalPath();
                            String wsdlLocationPath = new File(baseDir + File.separator + wsdlLocation).getAbsolutePath();
                            File file = new File(wsdlLocationPath);
                            URL url = file.toURI().toURL();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Reading WSDL from URL:" + url.toString()));
                            }
                            WSDL4JWrapper wsdlWrapper = new WSDL4JWrapper(url, false, 0);
                            return wsdlWrapper.getDefinition();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Exception getting wsdlLocation: " + e.getException()));
                }
            }
        }
        return wsdlDefinition;
    }

    static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }

    private static String getServiceImplClassName(EndpointDescription endpointDescription) {
        Parameter param;
        AxisService as;
        String result = null;
        if (endpointDescription != null && (as = endpointDescription.getAxisService()) != null && (param = as.getParameter("ServiceClass")) != null) {
            result = ((String)param.getValue()).trim();
        }
        return result;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }
}

