/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.description.AttachmentType;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Attachment;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.OccurrenceArray;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLitWrappedMinimalMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(DocLitWrappedMinimalMethodMarshaller.class);
    private static JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);

    @Override
    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc, Map<String, Object> requestContext) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter marshalRequest operationDesc = " + operationDesc.getName()));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.DOCUMENT);
            m.setIndirection(1);
            m.setOperationElement(DocLitWrappedMinimalMethodMarshaller.getRequestWrapperQName(operationDesc));
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, true, true);
            for (int i = 0; i < pdeList.size(); ++i) {
                PDElement pde = pdeList.get(i);
                pde = DocLitWrappedMinimalMethodMarshaller.processOccurrence(pde);
                pdeList.set(i, pde);
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages, requestContext);
            if (operationDesc.hasRequestSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit marshalRequest");
            }
            return m;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail marshalRequest e=" + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter demarshalRequest operationDesc = " + operationDesc.getName()));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.DOCUMENT);
            message.setIndirection(1);
            int[] firstIndex = new int[pds.length];
            int[] lastIndex = new int[pds.length];
            for (int i = 0; i < firstIndex.length; ++i) {
                firstIndex[i] = -1;
                lastIndex[i] = -1;
            }
            DocLitWrappedMinimalMethodMarshaller.calculateBodyIndex(firstIndex, lastIndex, pds, message.getBodyBlockQNames());
            Class[] javaTypes = new Class[pds.length];
            Class[] componentJavaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                javaTypes[i] = pd.getParameterActualType();
                componentJavaTypes[i] = javaTypes[i].isArray() ? javaTypes[i].getComponentType() : (javaTypes[i].isAssignableFrom(List.class) ? DocLitWrappedMinimalMethodMarshaller.getComponentType(pd, operationDesc, marshalDesc) : null);
            }
            List<PDElement> pvList = DocLitWrappedMinimalMethodMarshaller.getPDElementsForDocLitWrappedMinimal(pds, message, packages, true, false, javaTypes, componentJavaTypes, firstIndex, lastIndex);
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit demarshalRequest operationDesc");
            }
            return sigArguments;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail demarshalRequest e= " + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter marshalResponse operationDesc = " + operationDesc.getName()));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.DOCUMENT);
            m.setIndirection(1);
            QName responseOp = DocLitWrappedMinimalMethodMarshaller.getResponseWrapperQName(operationDesc);
            m.setOperationElement(responseOp);
            Class returnType = operationDesc.getResultActualType();
            String returnNS = null;
            String returnLocalPart = null;
            if (operationDesc.isResultHeader()) {
                returnNS = operationDesc.getResultTargetNamespace();
                returnLocalPart = operationDesc.getResultName();
            } else {
                returnNS = operationDesc.getResultTargetNamespace();
                returnLocalPart = operationDesc.getResultPartName();
            }
            if (returnType != Void.TYPE) {
                Element returnElement = null;
                QName returnQName = new QName(returnNS, returnLocalPart);
                if (DocLitWrappedMinimalMethodMarshaller.representAsOccurrence(returnObject, returnType)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Return element isListOrArray");
                    }
                    OccurrenceArray occurrenceArray = new OccurrenceArray(returnObject);
                    JAXBElement jaxb = new JAXBElement(returnQName, returnType, (Object)occurrenceArray);
                    returnElement = new Element(jaxb, returnQName);
                } else {
                    returnElement = marshalDesc.getAnnotationDesc(returnType).hasXmlRootElement() ? new Element(returnObject, returnQName) : new Element(returnObject, returnQName, returnType);
                }
                MethodMarshallerUtils.toMessage(returnElement, returnType, operationDesc.isListType(), marshalDesc, m, returnType, operationDesc.isResultHeader());
            }
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, true, false);
            for (int i = 0; i < pdeList.size(); ++i) {
                PDElement pde = pdeList.get(i);
                pde = DocLitWrappedMinimalMethodMarshaller.processOccurrence(pde);
                pdeList.set(i, pde);
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages, null);
            if (operationDesc.hasResponseSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit marshalResponse");
            }
            return m;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail marshalResponse e= " + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static PDElement processOccurrence(PDElement pde) {
        JAXBElement jaxb;
        Object value;
        Object elementValue;
        Element element = pde.getElement();
        if (element != null && (elementValue = element.getElementValue()) instanceof JAXBElement && DocLitWrappedMinimalMethodMarshaller.representAsOccurrence(value = (jaxb = (JAXBElement)elementValue).getValue(), jaxb.getDeclaredType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Build OccurrentArray");
            }
            OccurrenceArray occurrenceArray = new OccurrenceArray(value);
            JAXBElement newJAXBElement = new JAXBElement(jaxb.getName(), jaxb.getDeclaredType(), (Object)occurrenceArray);
            element = new Element(newJAXBElement, jaxb.getName());
            pde = new PDElement(pde.getParam(), element, null);
        }
        return pde;
    }

    private static boolean representAsOccurrence(Object value, Class inClass) {
        Class<?> cls;
        boolean rc = false;
        Class<?> clazz = cls = value == null ? inClass : value.getClass();
        if (cls == null) {
            return true;
        }
        if (List.class.isAssignableFrom(cls)) {
            rc = true;
        } else if (cls.equals(byte[].class)) {
            rc = false;
        } else if (cls.isArray()) {
            rc = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("representAsOccurrence for " + JavaUtils.getObjectIdentity((Object)value) + " of class: " + inClass + rc));
        }
        return rc;
    }

    @Override
    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter demarshalResponse operationDesc = " + operationDesc.getName()));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.DOCUMENT);
            message.setIndirection(1);
            int[] firstIndex = new int[pds.length];
            int[] lastIndex = new int[pds.length];
            for (int i = 0; i < firstIndex.length; ++i) {
                firstIndex[i] = -1;
                lastIndex[i] = -1;
            }
            DocLitWrappedMinimalMethodMarshaller.calculateBodyIndex(firstIndex, lastIndex, pds, message.getBodyBlockQNames());
            int firstBodyParamIndex = -1;
            for (int i = 0; i < pds.length; ++i) {
                if (pds[i].getMode() != WebParam.Mode.OUT && pds[i].getMode() != WebParam.Mode.INOUT || firstIndex[i] < 0 || firstBodyParamIndex != -1) continue;
                firstBodyParamIndex = firstIndex[i];
            }
            Class returnType = operationDesc.getResultActualType();
            Class returnComponentType = null;
            returnComponentType = returnType.isArray() ? returnType.getComponentType() : (returnType.isAssignableFrom(List.class) ? DocLitWrappedMinimalMethodMarshaller.getComponentType(null, operationDesc, marshalDesc) : null);
            Object returnValue = null;
            boolean hasReturnInBody = false;
            if (returnType != Void.TYPE) {
                Element returnElement = null;
                if (operationDesc.isResultHeader()) {
                    returnElement = DocLitWrappedMinimalMethodMarshaller.getReturnElementForDocLitWrappedMinimal(packages, message, returnType, returnComponentType, operationDesc.isListType(), true, operationDesc.getResultTargetNamespace(), operationDesc.getResultPartName(), MethodMarshallerUtils.numOutputBodyParams(pds) > 0, firstBodyParamIndex);
                } else {
                    returnElement = DocLitWrappedMinimalMethodMarshaller.getReturnElementForDocLitWrappedMinimal(packages, message, returnType, returnComponentType, operationDesc.isListType(), false, null, null, MethodMarshallerUtils.numOutputBodyParams(pds) > 0, firstBodyParamIndex);
                    hasReturnInBody = true;
                }
                returnValue = returnElement.getTypeValue();
            }
            Class[] javaTypes = new Class[pds.length];
            Class[] componentJavaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                Class type = pd.getParameterActualType();
                componentJavaTypes[i] = type.isArray() ? type.getComponentType() : (type.isAssignableFrom(List.class) ? DocLitWrappedMinimalMethodMarshaller.getComponentType(pd, operationDesc, marshalDesc) : null);
                javaTypes[i] = type;
            }
            List<PDElement> pvList = DocLitWrappedMinimalMethodMarshaller.getPDElementsForDocLitWrappedMinimal(pds, message, packages, false, hasReturnInBody, javaTypes, componentJavaTypes, firstIndex, lastIndex);
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit demarshalResponse");
            }
            return returnValue;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail demarshalResponse e=" + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("marshalFaultResponse operationDesc = " + operationDesc));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit marshalFaultResponse");
            }
            return m;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail marshalFaultResponse e=" + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("demarshalFaultResponse operationDesc = " + operationDesc));
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            if (log.isDebugEnabled()) {
                log.debug((Object)"exit demarshalFaultResponse");
            }
            return t;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fail demarshalFaultResponse e=" + e));
                log.debug((Object)(" " + JavaUtils.stackToString((Throwable)e)));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static QName getRequestWrapperQName(OperationDescription opDesc) {
        QName qName = opDesc.getName();
        String localPart = opDesc.getRequestWrapperLocalName();
        String uri = opDesc.getRequestWrapperTargetNamespace();
        String prefix = "dlwmin";
        qName = new QName(uri, localPart, prefix);
        return qName;
    }

    private static QName getResponseWrapperQName(OperationDescription opDesc) {
        QName qName = opDesc.getName();
        String localPart = opDesc.getResponseWrapperLocalName();
        String uri = opDesc.getResponseWrapperTargetNamespace();
        String prefix = "dlwmin";
        qName = new QName(uri, localPart, prefix);
        return qName;
    }

    static List<PDElement> getPDElementsForDocLitWrappedMinimal(ParameterDescription[] params, Message message, TreeSet<String> packages, boolean isInput, boolean hasReturnInBody, Class[] javaType, Class[] javaComponentType, int[] firstIndex, int[] lastIndex) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getPDElementsForDocLitWrappedMinimal");
        }
        ArrayList<PDElement> pdeList = new ArrayList<PDElement>();
        int totalBodyBlocks = message.getNumBodyBlocks();
        int swaIndex = 0;
        for (int i = 0; i < params.length; ++i) {
            ParameterDescription pd = params[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("  processing Parameter " + pd));
            }
            if ((pd.getMode() != WebParam.Mode.IN || !isInput) && pd.getMode() != WebParam.Mode.INOUT && (pd.getMode() != WebParam.Mode.OUT || isInput)) continue;
            Block block = null;
            JAXBBlockContext context = new JAXBBlockContext(packages);
            AttachmentDescription attachmentDesc = pd.getAttachmentDescription();
            if (attachmentDesc == null) {
                boolean isBase64Binary = byte[].class.equals((Object)javaType[i]);
                boolean unmarshalComponents = false;
                if (pd.isListType() || javaComponentType[i] == null || isBase64Binary) {
                    context.setProcessType(javaType[i]);
                    context.setIsxmlList(pd.isListType());
                } else {
                    context.setProcessType(javaComponentType[i]);
                    unmarshalComponents = true;
                }
                Element element = null;
                if (pd.isHeader()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  get block from the headers");
                    }
                    String localName = pd.getParameterName();
                    block = message.getHeaderBlock(pd.getTargetNamespace(), localName, context, factory);
                    element = new Element(block.getBusinessObject(true), block.getQName());
                } else if (firstIndex[i] >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  get block from the " + firstIndex[i] + " to the " + lastIndex[i]));
                    }
                    if (unmarshalComponents) {
                        Object container = DocLitWrappedMinimalMethodMarshaller.makeContainer(javaType[i], javaComponentType[i], lastIndex[i] - firstIndex[i] + 1);
                        for (int blockI = firstIndex[i]; blockI <= lastIndex[i]; ++blockI) {
                            block = message.getBodyBlock(blockI, context, factory);
                            Object value = block.getBusinessObject(true);
                            if (value instanceof JAXBElement) {
                                value = ((JAXBElement)value).getValue();
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(" get Business Object " + JavaUtils.getObjectIdentity((Object)value) + " from block " + blockI));
                            }
                            DocLitWrappedMinimalMethodMarshaller.addComponent(container, value, blockI - firstIndex[i]);
                        }
                        element = new Element(container, block.getQName());
                    } else {
                        block = message.getBodyBlock(firstIndex[i], context, factory);
                        element = new Element(block.getBusinessObject(true), block.getQName());
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  there is no block for this parameter.");
                    }
                    QName qName = new QName(pd.getTargetNamespace(), pd.getPartName());
                    if (!unmarshalComponents) {
                        element = new Element(null, qName);
                    } else {
                        Object container = DocLitWrappedMinimalMethodMarshaller.makeContainer(javaType[i], javaComponentType[i], 0);
                        element = new Element(container, qName);
                    }
                }
                PDElement pde = new PDElement(pd, element, javaComponentType[i] == null ? null : javaComponentType[i]);
                pdeList.add(pde);
                continue;
            }
            if (attachmentDesc.getAttachmentType() == AttachmentType.SWA) {
                String partName = pd.getPartName();
                String cid = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting the attachment dataHandler for partName=" + partName));
                }
                if (partName != null && partName.length() > 0) {
                    cid = message.getAttachmentID(partName);
                }
                if (cid == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Attachment dataHandler was not found.  Fallback to use attachment " + swaIndex));
                    }
                    cid = message.getAttachmentID(swaIndex);
                }
                DataHandler dh = message.getDataHandler(cid);
                Attachment attachment = new Attachment(dh, cid);
                PDElement pde = new PDElement(pd, null, null, attachment);
                pdeList.add(pde);
                ++swaIndex;
                continue;
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"pdElementErr"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end getPDElementsWithMissingElements");
        }
        return pdeList;
    }

    private static void calculateBodyIndex(int[] firstIndex, int[] lastIndex, ParameterDescription[] params, List<QName> qNames) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start calculateBodyIndex");
            for (int i = 0; i < qNames.size(); ++i) {
                log.debug((Object)("   QName " + i + " = " + qNames.get(i)));
            }
        }
        for (int pi = 0; pi < params.length; ++pi) {
            QName qName;
            int qi;
            if (pi < 0) continue;
            ParameterDescription pd = params[pi];
            if (log.isDebugEnabled()) {
                log.debug((Object)("  ParameterDescription =" + pd.toString()));
                log.debug((Object)("  original firstIndex = " + firstIndex[pi]));
                log.debug((Object)("  original lastIndex = " + lastIndex[pi]));
            }
            firstIndex[pi] = -1;
            lastIndex[pi] = -1;
            for (qi = 0; qi < qNames.size(); ++qi) {
                qName = qNames.get(qi);
                if (!qName.getLocalPart().equals(pd.getPartName()) || !qName.getNamespaceURI().equals(pd.getTargetNamespace())) continue;
                if (firstIndex[pi] < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    set first index to " + qi));
                    }
                    firstIndex[pi] = qi;
                }
                lastIndex[pi] = qi;
            }
            if (firstIndex[pi] < 0) {
                for (qi = 0; qi < qNames.size(); ++qi) {
                    qName = qNames.get(qi);
                    if (!qName.getLocalPart().equals(pd.getPartName())) continue;
                    if (firstIndex[pi] < 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("    fallback: set first index to " + qi));
                        }
                        firstIndex[pi] = qi;
                    }
                    lastIndex[pi] = qi;
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("  last index = " + lastIndex[pi]));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End calculateBodyIndex");
        }
    }

    static Element getReturnElementForDocLitWrappedMinimal(TreeSet<String> packages, Message message, Class javaTypeClass, Class javaComponentTypeClass, boolean isList, boolean isHeader, String headerNS, String headerLocalPart, boolean hasOutputBodyParams, int outputBodyArgIndex) throws WebServiceException, XMLStreamException {
        JAXBBlockContext context = new JAXBBlockContext(packages);
        boolean unmarshalComponents = false;
        if (isList || javaComponentTypeClass == null) {
            context.setProcessType(javaTypeClass);
            context.setIsxmlList(isList);
        } else {
            context.setProcessType(javaComponentTypeClass);
            unmarshalComponents = true;
        }
        Element returnElement = null;
        if (isHeader) {
            Block block = message.getHeaderBlock(headerNS, headerLocalPart, context, factory);
            returnElement = new Element(block.getBusinessObject(true), block.getQName());
        } else {
            int numBodyBlocks = message.getNumBodyBlocks();
            if (outputBodyArgIndex >= 0) {
                numBodyBlocks = outputBodyArgIndex;
            }
            if (!unmarshalComponents) {
                if (numBodyBlocks == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Case A: Not unmarshalling components, and only 1 block");
                    }
                    Block block = message.getBodyBlock(context, factory);
                    returnElement = new Element(block.getBusinessObject(true), block.getQName());
                } else if (numBodyBlocks > 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Case B: Not unmarshalling components, and multiple blocks");
                    }
                    Block block = message.getBodyBlock(0, context, factory);
                    returnElement = new Element(block.getBusinessObject(true), block.getQName());
                }
            } else if (numBodyBlocks > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Case C: unmarshalling components.  Number of blocks=" + numBodyBlocks));
                }
                List<QName> qNames = message.getBodyBlockQNames();
                int firstIndex = 0;
                int lastIndex = 0;
                QName returnQName = qNames.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" returnQName =" + returnQName));
                }
                while (++lastIndex < qNames.size() && returnQName.equals(qNames.get(lastIndex))) {
                }
                int numElements = lastIndex - firstIndex;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" number of return blocks=" + numElements));
                }
                Object container = DocLitWrappedMinimalMethodMarshaller.makeContainer(javaTypeClass, javaComponentTypeClass, numElements);
                for (int blockI = firstIndex; blockI < lastIndex; ++blockI) {
                    Block block = message.getBodyBlock(blockI, context, factory);
                    Object value = block.getBusinessObject(true);
                    if (value instanceof JAXBElement) {
                        value = ((JAXBElement)value).getValue();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" get return Business object (" + JavaUtils.getObjectIdentity((Object)value) + ") for block " + blockI));
                    }
                    DocLitWrappedMinimalMethodMarshaller.addComponent(container, value, blockI);
                }
                returnElement = new Element(container, returnQName);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Case D: unmarshalling components, but there are no blocks");
                }
                Object container = DocLitWrappedMinimalMethodMarshaller.makeContainer(javaTypeClass, javaComponentTypeClass, 0);
                QName qName = new QName("", "return");
                returnElement = new Element(container, qName);
            }
            if (returnElement == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Empty Body Block Found in response Message for wsdl Operation defintion that expects an Output");
                    log.debug((Object)"Return type associated with SEI operation is not void, Body Block cannot be null");
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"MethodMarshallerUtilErr1"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReturnElementForDocLitWrappedMinimal " + JavaUtils.getObjectIdentity((Object)returnElement)));
        }
        return returnElement;
    }

    private static Object makeContainer(Class type, Class componentType, int numComponents) {
        ArrayList container = null;
        if (type.isArray()) {
            container = Array.newInstance(componentType, numComponents);
        } else {
            try {
                container = type.newInstance();
            }
            catch (Exception e) {
                container = new ArrayList();
            }
        }
        return container;
    }

    private static void addComponent(Object container, Object component, int index) {
        if (container.getClass().isArray()) {
            if (component != null) {
                Array.set(container, index, component);
            }
        } else {
            ((List)container).add(component);
        }
    }

    private static Class getComponentType(ParameterDescription pd, OperationDescription operationDesc, MarshalServiceRuntimeDescription msrd) {
        Class componentType = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getComponentType");
            log.debug((Object)(" ParameterDescription=" + pd));
        }
        Class cls = null;
        cls = pd == null ? operationDesc.getResultActualType() : pd.getParameterActualType();
        if (cls != null) {
            if (cls.isArray()) {
                componentType = cls.getComponentType();
            } else if (List.class.isAssignableFrom(cls)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parameter is a List: " + cls));
                }
                Method method = msrd.getMethod(operationDesc);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Method is: " + method));
                }
                Type genericType = null;
                if (pd == null) {
                    genericType = method.getGenericReturnType();
                } else {
                    ParameterDescription[] pds = operationDesc.getParameterDescriptions();
                    for (int i = 0; i < pds.length; ++i) {
                        if (pds[i] != pd) continue;
                        genericType = method.getGenericParameterTypes()[i];
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("genericType is: " + genericType.getClass() + " " + genericType));
                }
                if (genericType instanceof Class) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)" genericType instanceof Class");
                    }
                    componentType = String.class;
                } else if (genericType instanceof ParameterizedType) {
                    ParameterizedType pt;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)" genericType instanceof ParameterizedType");
                    }
                    if ((pt = (ParameterizedType)genericType).getRawType() == Holder.class) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)" strip off holder");
                        }
                        if ((genericType = pt.getActualTypeArguments()[0]) instanceof Class) {
                            componentType = String.class;
                        } else if (genericType instanceof ParameterizedType) {
                            pt = (ParameterizedType)genericType;
                        }
                    }
                    if (componentType == null) {
                        Type comp = pt.getActualTypeArguments()[0];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" comp =" + comp.getClass() + " " + comp));
                        }
                        if (comp instanceof Class) {
                            componentType = (Class)comp;
                        } else if (comp instanceof ParameterizedType) {
                            componentType = (Class)((ParameterizedType)comp).getRawType();
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end getComponentType=" + componentType));
        }
        return componentType;
    }
}

