/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.snmp;

import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SynapseMOScalar
extends MOScalar<Variable> {
    private static final Log log = LogFactory.getLog(SynapseMOScalar.class);
    private ObjectName objectName;
    private String attribute;
    private int snmpVersion;

    public SynapseMOScalar(OID id, ObjectName objectName, String attribute, int snmpVersion) {
        super(id, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new OctetString());
        this.objectName = objectName;
        this.attribute = attribute;
        this.snmpVersion = snmpVersion;
    }

    public Variable getValue() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Object obj = mbs.getAttribute(this.objectName, this.attribute);
            if (obj instanceof Integer) {
                return new Integer32(((Integer)obj).intValue());
            }
            if (this.snmpVersion > 0) {
                if (obj instanceof Long) {
                    return new Counter64(((Long)obj).longValue());
                }
                if (obj instanceof Date) {
                    return new Counter64(((Date)obj).getTime());
                }
            }
            return new OctetString(obj.toString());
        }
        catch (Exception e) {
            log.error((Object)("Unexpected error while retrieving the value of OID: " + this.getID()), (Throwable)e);
            return null;
        }
    }
}

