/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.StringUtils;

public class WebMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 7323361588604247458L;
    private final String resourceBasePath;

    public WebMergedContextConfiguration(MergedContextConfiguration mergedConfig, String resourceBasePath) {
        super(mergedConfig);
        this.resourceBasePath = StringUtils.hasText((String)resourceBasePath) ? resourceBasePath : "";
    }

    public WebMergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, null, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public WebMergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, @Nullable Set<ContextCustomizer> contextCustomizers, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        super(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, contextCustomizers, contextLoader, cacheAwareContextLoaderDelegate, parent);
        this.resourceBasePath = StringUtils.hasText((String)resourceBasePath) ? resourceBasePath : "";
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || super.equals(other) && this.resourceBasePath.equals(((WebMergedContextConfiguration)other).resourceBasePath);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.resourceBasePath.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this, (ToStringStyler)new DefaultToStringStyler((ValueStyler)new SimpleValueStyler())).append("testClass", this.getTestClass()).append("locations", (Object)this.getLocations()).append("classes", this.getClasses()).append("contextInitializerClasses", this.getContextInitializerClasses()).append("activeProfiles", (Object)this.getActiveProfiles()).append("propertySourceLocations", (Object)this.getPropertySourceLocations()).append("propertySourceProperties", (Object)this.getPropertySourceProperties()).append("contextCustomizers", this.getContextCustomizers()).append("resourceBasePath", (Object)this.getResourceBasePath()).append("contextLoader", this.getContextLoader() != null ? this.getContextLoader().getClass() : null).append("parent", (Object)this.getParent()).toString();
    }
}

