/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.struts2.ognl.DefaultOgnlCacheFactory;
import org.apache.struts2.ognl.OgnlCache;
import org.apache.struts2.ognl.OgnlCacheFactory;
import org.apache.struts2.util.ClassLoaderUtil;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;

public class ProxyUtil {
    private static final String SPRING_ADVISED_CLASS_NAME = "org.springframework.aop.framework.Advised";
    private static final String SPRING_SPRINGPROXY_CLASS_NAME = "org.springframework.aop.SpringProxy";
    private static final String SPRING_SINGLETONTARGETSOURCE_CLASS_NAME = "org.springframework.aop.target.SingletonTargetSource";
    private static final String SPRING_TARGETCLASSAWARE_CLASS_NAME = "org.springframework.aop.TargetClassAware";
    private static final String HIBERNATE_HIBERNATEPROXY_CLASS_NAME = "org.hibernate.proxy.HibernateProxy";
    private static final int CACHE_MAX_SIZE = 10000;
    private static final int CACHE_INITIAL_CAPACITY = 256;
    private static final OgnlCache<Class<?>, Boolean> isProxyCache = new DefaultOgnlCacheFactory(10000, OgnlCacheFactory.CacheType.WTLFU, 256).buildOgnlCache();
    private static final OgnlCache<Member, Boolean> isProxyMemberCache = new DefaultOgnlCacheFactory(10000, OgnlCacheFactory.CacheType.WTLFU, 256).buildOgnlCache();

    public static Class<?> ultimateTargetClass(Object candidate) {
        Class<?> result = null;
        if (ProxyUtil.isSpringAopProxy(candidate)) {
            result = ProxyUtil.springUltimateTargetClass(candidate);
        }
        if (result == null) {
            result = candidate.getClass();
        }
        return result;
    }

    public static boolean isProxy(Object object) {
        Class<?> clazz = object.getClass();
        Boolean flag = isProxyCache.get(clazz);
        if (flag != null) {
            return flag;
        }
        boolean isProxy = ProxyUtil.isSpringAopProxy(object) || ProxyUtil.isHibernateProxy(object);
        isProxyCache.put(clazz, isProxy);
        return isProxy;
    }

    public static boolean isProxyMember(Member member, Object object) {
        if (!(Modifier.isStatic(member.getModifiers()) || ProxyUtil.isProxy(object) || ProxyUtil.isHibernateProxy(object))) {
            return false;
        }
        Boolean flag = isProxyMemberCache.get(member);
        if (flag != null) {
            return flag;
        }
        boolean isProxyMember = ProxyUtil.isSpringProxyMember(member) || ProxyUtil.isHibernateProxyMember(member);
        isProxyMemberCache.put(member, isProxyMember);
        return isProxyMember;
    }

    public static boolean isHibernateProxy(Object object) {
        try {
            return HibernateProxy.class.isAssignableFrom(object.getClass());
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static boolean isHibernateProxyMember(Member member) {
        try {
            Class clazz = ClassLoaderUtil.loadClass(HIBERNATE_HIBERNATEPROXY_CLASS_NAME, ProxyUtil.class);
            return ProxyUtil.hasMember(clazz, member);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Class<?> springUltimateTargetClass(Object candidate) {
        Object current = candidate;
        Class<?> result = null;
        while (null != current && ProxyUtil.implementsInterface(current.getClass(), SPRING_TARGETCLASSAWARE_CLASS_NAME)) {
            try {
                result = (Class<?>)MethodUtils.invokeMethod((Object)current, (String)"getTargetClass");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            current = ProxyUtil.getSingletonTarget(current);
        }
        if (result == null) {
            Class<?> clazz = candidate.getClass();
            result = ProxyUtil.isCglibProxyClass(clazz) ? clazz.getSuperclass() : candidate.getClass();
        }
        return result;
    }

    private static boolean isSpringAopProxy(Object object) {
        Class<?> clazz = object.getClass();
        return ProxyUtil.implementsInterface(clazz, SPRING_SPRINGPROXY_CLASS_NAME) && (Proxy.isProxyClass(clazz) || ProxyUtil.isCglibProxyClass(clazz));
    }

    private static boolean isSpringProxyMember(Member member) {
        try {
            Class clazz = ClassLoaderUtil.loadClass(SPRING_ADVISED_CLASS_NAME, ProxyUtil.class);
            if (ProxyUtil.hasMember(clazz, member)) {
                return true;
            }
            clazz = ClassLoaderUtil.loadClass(SPRING_TARGETCLASSAWARE_CLASS_NAME, ProxyUtil.class);
            if (ProxyUtil.hasMember(clazz, member)) {
                return true;
            }
            clazz = ClassLoaderUtil.loadClass(SPRING_SPRINGPROXY_CLASS_NAME, ProxyUtil.class);
            if (ProxyUtil.hasMember(clazz, member)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static Object getSingletonTarget(Object candidate) {
        try {
            Object targetSource;
            if (ProxyUtil.implementsInterface(candidate.getClass(), SPRING_ADVISED_CLASS_NAME) && ProxyUtil.implementsInterface((targetSource = MethodUtils.invokeMethod((Object)candidate, (String)"getTargetSource")).getClass(), SPRING_SINGLETONTARGETSOURCE_CLASS_NAME)) {
                return MethodUtils.invokeMethod((Object)targetSource, (String)"getTarget");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && clazz.getName().contains("$$");
    }

    private static boolean implementsInterface(Class<?> clazz, String ifaceClassName) {
        try {
            Class ifaceClass = ClassLoaderUtil.loadClass(ifaceClassName, ProxyUtil.class);
            return ifaceClass.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean hasMember(Class<?> clazz, Member member) {
        if (member instanceof Method) {
            return null != MethodUtils.getMatchingMethod(clazz, (String)member.getName(), (Class[])((Method)member).getParameterTypes());
        }
        if (member instanceof Field) {
            return null != FieldUtils.getField(clazz, (String)member.getName(), (boolean)true);
        }
        if (member instanceof Constructor) {
            return null != ConstructorUtils.getMatchingAccessibleConstructor(clazz, (Class[])((Constructor)member).getParameterTypes());
        }
        return false;
    }

    public static Object getHibernateProxyTarget(Object object) {
        try {
            return Hibernate.unproxy((Object)object);
        }
        catch (NoClassDefFoundError ignored) {
            return object;
        }
    }

    public static Member resolveTargetMember(Member proxyMember, Object target) {
        int mod = proxyMember.getModifiers();
        if (proxyMember instanceof Method) {
            if (Modifier.isPublic(mod)) {
                return MethodUtils.getMatchingAccessibleMethod(target.getClass(), (String)proxyMember.getName(), (Class[])((Method)proxyMember).getParameterTypes());
            }
            return MethodUtils.getMatchingMethod(target.getClass(), (String)proxyMember.getName(), (Class[])((Method)proxyMember).getParameterTypes());
        }
        if (proxyMember instanceof Field) {
            return FieldUtils.getField(target.getClass(), (String)proxyMember.getName(), (boolean)Modifier.isPublic(mod));
        }
        if (proxyMember instanceof Constructor && Modifier.isPublic(mod)) {
            return ConstructorUtils.getMatchingAccessibleConstructor(target.getClass(), (Class[])((Constructor)proxyMember).getParameterTypes());
        }
        return proxyMember;
    }
}

