/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.freemarker;

import freemarker.core.Environment;
import freemarker.ext.servlet.HttpRequestHashModel;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.request.AbstractViewRequest;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.DispatchRequest;
import org.apache.tiles.request.freemarker.EnvironmentScopeMap;
import org.apache.tiles.request.freemarker.FreemarkerRequestUtil;
import org.apache.tiles.request.servlet.ServletRequest;

public class FreemarkerRequest
extends AbstractViewRequest {
    private final List<String> scopes;
    private final Environment env;
    private Map<String, Object> pageScope;

    public static FreemarkerRequest createServletFreemarkerRequest(ApplicationContext applicationContext, Environment env) {
        HttpRequestHashModel requestModel = FreemarkerRequestUtil.getRequestHashModel(env);
        HttpServletRequest request = requestModel.getRequest();
        HttpServletResponse response = requestModel.getResponse();
        ServletRequest enclosedRequest = new ServletRequest(applicationContext, request, response);
        return new FreemarkerRequest(enclosedRequest, env);
    }

    public FreemarkerRequest(DispatchRequest enclosedRequest, Environment env) {
        super(enclosedRequest);
        ArrayList<String> scopes = new ArrayList<String>(enclosedRequest.getAvailableScopes());
        scopes.add("page");
        this.scopes = Collections.unmodifiableList(scopes);
        this.env = env;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    @Override
    public Locale getRequestLocale() {
        return this.env.getLocale();
    }

    public Map<String, Object> getPageScope() {
        if (this.pageScope == null) {
            this.pageScope = new EnvironmentScopeMap(this.env);
        }
        return this.pageScope;
    }

    @Override
    public List<String> getAvailableScopes() {
        return this.scopes;
    }

    @Override
    public PrintWriter getPrintWriter() {
        Writer writer = this.env.getOut();
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(writer);
    }

    @Override
    public Writer getWriter() {
        return this.env.getOut();
    }

    @Override
    public Map<String, Object> getContext(String scope) {
        return "page".equals(scope) ? this.getPageScope() : super.getContext(scope);
    }
}

