/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.xml;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.transconsole.common.messages.Message;
import com.google.transconsole.common.messages.MessageBundle;
import java.io.IOException;

public class XmbBundleWriter {
    private final MessageBundle bundle;
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE messagebundle SYSTEM \"/home/build/nonconf/google3/i18n/messagebundle.dtd\">\n<messagebundle>\n";
    private static final String FOOTER = "</messagebundle>\n";

    public XmbBundleWriter(MessageBundle bundle) {
        this.bundle = Preconditions.checkNotNull(bundle);
    }

    public void write(Appendable out) throws IOException {
        this.writeHeader(out);
        this.writeBody(out);
        this.writeFooter(out);
    }

    protected void writeHeader(Appendable out) throws IOException {
        out.append(HEADER);
    }

    protected void writeFooter(Appendable out) throws IOException {
        out.append(FOOTER);
    }

    protected void writeBody(Appendable out) throws IOException {
        for (Message m : this.bundle) {
            out.append(m.toXml());
            out.append('\n');
        }
    }
}

