/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.collect.Maps;
import com.google.transconsole.common.messages.InvalidMessageException;
import com.google.transconsole.common.messages.Message;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.MessageProperties;
import com.google.transconsole.common.messages.Placeholder;
import com.google.transconsole.common.messages.TextFragment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageBuilder {
    private String id;
    private List<MessageFragment> fragments = new ArrayList<MessageFragment>();
    private MessageProperties properties = new MessageProperties();
    private boolean preserveWhitespace;

    public MessageBuilder() {
        this(true);
    }

    public MessageBuilder(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public MessageBuilder appendText(String text) {
        this.fragments.add(new TextFragment(text));
        return this;
    }

    public MessageBuilder appendPlaceholder(String original, String presentation, String example) throws InvalidMessageException {
        if (presentation == null || presentation.length() == 0) {
            throw new InvalidMessageException("Invalid placeholder specification: presentation required");
        }
        if (example == null || example.length() == 0) {
            throw new InvalidMessageException("Invalid placeholder specification: example required");
        }
        if (!presentation.matches("^[A-Z0-9_]+$")) {
            throw new InvalidMessageException("Invalid placeholder specification: only caps, digits, and underscores allowed in presentation");
        }
        Placeholder p = new Placeholder(original, presentation, example);
        for (MessageFragment f : this.fragments) {
            if (!p.conflictsWith(f)) continue;
            throw new InvalidMessageException("Conflicting declarations of " + presentation + " within message");
        }
        this.fragments.add(p);
        return this;
    }

    public MessageBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public MessageBuilder setContentType(String contentType) {
        this.properties.setContentType(contentType);
        return this;
    }

    public MessageBuilder setDescription(String description) {
        this.properties.setDescription(description);
        return this;
    }

    public MessageBuilder setMeaning(String meaning) {
        this.properties.setMeaning(meaning);
        return this;
    }

    public MessageBuilder setHidden(boolean isHidden) {
        this.properties.setHidden(isHidden);
        return this;
    }

    public MessageBuilder setName(String name) {
        this.properties.setName(name);
        return this;
    }

    public MessageBuilder setObsolete(boolean isObsolete) {
        this.properties.setObsolete(isObsolete);
        return this;
    }

    public MessageBuilder addSource(String source) {
        this.properties.addSource(source);
        return this;
    }

    public Message createMessage() throws InvalidMessageException {
        if (!this.preserveWhitespace && this.fragments.size() != 0) {
            this.stripSpacesFromFragments();
        }
        Message m = this.id == null ? new Message(this.fragments, this.properties) : new Message(this.id, this.fragments, this.properties);
        this.checkForPlaceholdersOverlap(m);
        return m;
    }

    private void checkForPlaceholdersOverlap(Message m) throws InvalidMessageException {
        int pos = 0;
        HashMap<Integer, Placeholder> phs = Maps.newHashMap();
        for (MessageFragment f : this.fragments) {
            if (f instanceof Placeholder) {
                phs.put(pos, (Placeholder)f);
            }
            pos += f.getPresentation().length();
        }
        String presentation = m.getPresentation();
        for (MessageFragment f : this.fragments) {
            if (!(f instanceof Placeholder)) continue;
            int start = presentation.indexOf(f.getPresentation(), 0);
            while (start > -1) {
                Placeholder otherPh = (Placeholder)phs.get(start);
                if (otherPh == null && !this.isSubstringInPlaceholder(start, f.getPresentation().length(), phs) || otherPh != null && otherPh.getPresentation().length() < f.getPresentation().length()) {
                    throw new InvalidMessageException(m.getId(), "Placeholder name (" + f.getPresentation() + ") duplicated in message content.");
                }
                start = presentation.indexOf(f.getPresentation(), start + 1);
            }
        }
    }

    private boolean isSubstringInPlaceholder(int pos, int len, HashMap<Integer, Placeholder> phs) {
        for (Map.Entry<Integer, Placeholder> e : phs.entrySet()) {
            if (pos <= e.getKey() || pos + len > e.getKey() + e.getValue().getPresentation().length()) continue;
            return true;
        }
        return false;
    }

    private void stripSpacesFromFragments() {
        int lastIndex;
        MessageFragment fragment = this.fragments.get(0);
        if (fragment instanceof TextFragment) {
            String presentation = MessageBuilder.trimLeft(fragment.getPresentation());
            this.fragments.set(0, new TextFragment(presentation));
        }
        if ((fragment = this.fragments.get(lastIndex = this.fragments.size() - 1)) instanceof TextFragment) {
            String presentation = MessageBuilder.trimRight(fragment.getPresentation());
            this.fragments.set(lastIndex, new TextFragment(presentation));
        }
    }

    private static String trimLeft(String s) {
        int i;
        int limit = s.length() - 1;
        for (i = 0; i <= limit && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    private static String trimRight(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }
}

