/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base.dynamic;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.html.HtmlClosure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class FilePrinter
implements HtmlClosure {
    private static final int SURROUND_LINES = 5;
    private Reader fileReader;
    private long startLine;
    private long endLine;
    private long errorLine;

    public FilePrinter(Reader fileReader, long errorLine) {
        this.fileReader = fileReader;
        this.errorLine = errorLine;
        this.startLine = Math.max(0L, errorLine - 5L);
        this.endLine = errorLine + 5L;
    }

    @Override
    public void write(Appendable out, GxpContext gxpContext) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(this.fileReader);
        for (long lineNumber = 1L; (line = br.readLine()) != null && lineNumber <= this.endLine; ++lineNumber) {
            if (this.startLine > lineNumber) continue;
            if (lineNumber == this.errorLine) {
                out.append("<span class=\"error\">");
            }
            out.append(String.format("%4d: ", lineNumber));
            CharEscapers.asciiHtmlEscaper().escape(out).append(line);
            if (lineNumber == this.errorLine) {
                out.append("</span>");
            }
            out.append('\n');
        }
    }
}

