/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class DateConverter
extends DefaultTypeConverter {
    @Override
    public Object convertValue(Map<String, Object> context, Object target, Member member, String propertyName, Object value, Class toType) {
        Date result;
        block20: {
            result = null;
            if (value instanceof String && value != null && ((String)value).length() > 0) {
                Date check;
                String sa = (String)value;
                Locale locale = this.getLocale(context);
                DateFormat df = null;
                if (Time.class == toType) {
                    df = DateFormat.getTimeInstance(2, locale);
                } else if (Timestamp.class == toType) {
                    SimpleDateFormat[] fmts;
                    check = null;
                    SimpleDateFormat dtfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
                    SimpleDateFormat fullfmt = new SimpleDateFormat(dtfmt.toPattern() + MILLISECOND_FORMAT, locale);
                    SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
                    for (SimpleDateFormat fmt : fmts = new SimpleDateFormat[]{fullfmt, dtfmt, dfmt}) {
                        try {
                            check = fmt.parse(sa);
                            df = fmt;
                            if (check == null) continue;
                            break;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                } else if (Date.class == toType) {
                    DateFormat[] dfs;
                    for (DateFormat df1 : dfs = this.getDateFormats(locale)) {
                        try {
                            check = df1.parse(sa);
                            df = df1;
                            if (check == null) continue;
                            break;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
                if (df == null) {
                    df = DateFormat.getDateInstance(3, locale);
                }
                try {
                    df.setLenient(false);
                    result = df.parse(sa);
                    if (Date.class != toType) {
                        try {
                            Constructor constructor = toType.getConstructor(Long.TYPE);
                            return constructor.newInstance(result.getTime());
                        }
                        catch (Exception e) {
                            throw new XWorkException("Couldn't create class " + toType + " using default (long) constructor", e);
                        }
                    }
                    break block20;
                }
                catch (ParseException e) {
                    throw new XWorkException("Could not parse date", e);
                }
            }
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = (Date)value;
            }
        }
        return result;
    }

    private DateFormat[] getDateFormats(Locale locale) {
        DateFormat dt1 = DateFormat.getDateTimeInstance(3, 1, locale);
        DateFormat dt2 = DateFormat.getDateTimeInstance(3, 2, locale);
        DateFormat dt3 = DateFormat.getDateTimeInstance(3, 3, locale);
        DateFormat d1 = DateFormat.getDateInstance(3, locale);
        DateFormat d2 = DateFormat.getDateInstance(2, locale);
        DateFormat d3 = DateFormat.getDateInstance(1, locale);
        SimpleDateFormat rfc3339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat rfc3339dateOnly = new SimpleDateFormat("yyyy-MM-dd");
        return new DateFormat[]{dt1, dt2, dt3, rfc3339, d1, d2, d3, rfc3339dateOnly};
    }
}

