/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.localization.context;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.oval.Validator;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.Log;
import net.sf.oval.localization.context.OValContextRenderer;

public class ResourceBundleValidationContextRenderer
implements OValContextRenderer {
    private static final Log LOG = Log.getLog(ResourceBundleValidationContextRenderer.class);
    public static final ResourceBundleValidationContextRenderer INSTANCE = new ResourceBundleValidationContextRenderer();

    private static boolean containsKey(ResourceBundle bundle, String key) {
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            if (!en.nextElement().equals(key)) continue;
            return true;
        }
        return false;
    }

    protected Locale getLocale() {
        return Validator.getLocaleProvider().getLocale();
    }

    public String render(OValContext ovalContext) {
        String key;
        String baseName;
        OValContext ctx;
        if (ovalContext instanceof ClassContext) {
            ctx = (ClassContext)ovalContext;
            baseName = ((ClassContext)ctx).getClazz().getName();
            key = "label.class";
        } else if (ovalContext instanceof FieldContext) {
            ctx = (FieldContext)ovalContext;
            baseName = ((FieldContext)ctx).getField().getDeclaringClass().getName();
            String fieldName = ((FieldContext)ctx).getField().getName();
            key = "label.field." + fieldName;
        } else if (ovalContext instanceof ConstructorParameterContext) {
            ctx = (ConstructorParameterContext)ovalContext;
            baseName = ((ConstructorParameterContext)ctx).getConstructor().getDeclaringClass().getName();
            key = "label.parameter." + ((ConstructorParameterContext)ctx).getParameterName();
        } else if (ovalContext instanceof MethodParameterContext) {
            ctx = (MethodParameterContext)ovalContext;
            baseName = ((MethodParameterContext)ctx).getMethod().getDeclaringClass().getName();
            key = "label.parameter." + ((MethodParameterContext)ctx).getParameterName();
        } else if (ovalContext instanceof MethodEntryContext) {
            ctx = (MethodEntryContext)ovalContext;
            baseName = ((MethodEntryContext)ctx).getMethod().getDeclaringClass().getName();
            key = "label.method." + ((MethodEntryContext)ctx).getMethod().getName();
        } else if (ovalContext instanceof MethodExitContext) {
            ctx = (MethodExitContext)ovalContext;
            baseName = ((MethodExitContext)ctx).getMethod().getDeclaringClass().getName();
            key = "label.method." + ((MethodExitContext)ctx).getMethod().getName();
        } else if (ovalContext instanceof MethodReturnValueContext) {
            ctx = (MethodReturnValueContext)ovalContext;
            baseName = ((MethodReturnValueContext)ctx).getMethod().getDeclaringClass().getName();
            key = "label.method." + ((MethodReturnValueContext)ctx).getMethod().getName();
        } else {
            return ovalContext.toString();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, this.getLocale());
            if (ResourceBundleValidationContextRenderer.containsKey(bundle, key)) {
                return bundle.getString(key);
            }
            LOG.debug("Key {1} not found in bundle {2}", (Object)key, baseName);
        }
        catch (MissingResourceException ex) {
            LOG.debug("Bundle {1} not found", (Object)baseName, ex);
        }
        return ovalContext.toString();
    }
}

