/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class ScaleHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/scale";
    public static final String PN_BOTH = "both";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        ValueMap properties = config.getProperties();
        double both = (Double)properties.get(PN_BOTH, (Object)-1.0);
        double width = (Double)properties.get("width", (Object)-1.0);
        double height = (Double)properties.get("height", (Object)-1.0);
        try {
            Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
            if (both >= 0.0) {
                builder.scale(both);
            } else if (width >= 0.0 && height >= 0.0) {
                builder.scale(width, height);
            } else {
                throw new BadRequestException("Could not scale thumbnail, invalid parameters: \n%s", properties);
            }
            builder.toOutputStream(outputStream);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Unable to resize due to invalid configuration: \n%s", config.getProperties(), e);
        }
    }
}

