/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class ResizeHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/resize";
    public static final String PN_HEIGHT = "height";
    public static final String PN_WIDTH = "width";
    public static final String PN_KEEP_ASPECT_RATIO = "keepAspectRatio";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        try {
            ResizeHandler.resize((Thumbnails.Builder<? extends InputStream>)builder, config.getProperties());
            boolean keepAspectRatio = (Boolean)config.getProperties().get(PN_KEEP_ASPECT_RATIO, (Object)true);
            builder.keepAspectRatio(keepAspectRatio);
            builder.toOutputStream(outputStream);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Unable to resize due to invalid configuration: \n%s", config.getProperties(), e);
        }
    }

    private static void resize(Thumbnails.Builder<? extends InputStream> builder, ValueMap properties) {
        int width = (Integer)properties.get(PN_WIDTH, (Object)-1);
        int height = (Integer)properties.get(PN_HEIGHT, (Object)-1);
        if (width >= 0 && height >= 0) {
            builder.size(width, height);
        } else if (width >= 0) {
            builder.width(width);
        } else if (height >= 0) {
            builder.height(height);
        } else {
            throw new BadRequestException("Unable to resize thumbnail due to invalid parameters: \n%s", properties);
        }
    }
}

