/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.OutputFileFormat;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.Transformation;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.Transformer;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Transformer.class})
public class TransformerImpl
implements Transformer {
    private static final Logger log = LoggerFactory.getLogger(TransformerImpl.class);
    private final List<TransformationHandler> handlers;
    private final List<ThumbnailProvider> thumbnailProviders;
    private final ThumbnailSupport thumbnailSupport;

    @Activate
    public TransformerImpl(@Reference(service=ThumbnailProvider.class, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.AT_LEAST_ONE) List<ThumbnailProvider> thumbnailProviders, @Reference ThumbnailSupport thumbnailSupport, @Reference(service=TransformationHandler.class, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.AT_LEAST_ONE) List<TransformationHandler> handlers) {
        this.thumbnailProviders = thumbnailProviders;
        this.thumbnailSupport = thumbnailSupport;
        this.handlers = handlers;
    }

    public List<TransformationHandler> getHandlers() {
        return this.handlers;
    }

    private String getMetaType(Resource resource) {
        return (String)resource.getValueMap().get(this.thumbnailSupport.getMetaTypePropertyPath(resource.getResourceType()), String.class);
    }

    private ThumbnailProvider getThumbnailProvider(Resource resource) throws IOException {
        String metaType = this.getMetaType(resource);
        log.debug("Finding thumbnail provider for resource {} with meta type {} from available providers {}", new Object[]{resource, metaType, this.thumbnailProviders});
        return this.thumbnailProviders.stream().filter(tp -> {
            log.debug("Checking provider: {}", tp);
            return tp.applies(resource, metaType);
        }).findFirst().orElseThrow(() -> new IOException("Unable to find thumbnail provider for: " + resource.getPath()));
    }

    public List<ThumbnailProvider> getThumbnailProviders() {
        return this.thumbnailProviders;
    }

    public TransformationHandler getTransformationHandler(String resourceType) {
        return this.handlers.stream().filter(h -> resourceType.equals(h.getResourceType())).findFirst().orElse(null);
    }

    @Override
    public void transform(Resource resource, Transformation transformation, OutputFileFormat format, OutputStream out) throws IOException {
        if (!this.thumbnailSupport.getSupportedTypes().contains(resource.getResourceType())) {
            throw new BadRequestException("Unsupported resource type: " + resource.getResourceType());
        }
        ThumbnailProvider provider = this.getThumbnailProvider(resource);
        log.debug("Using thumbnail provider {} for resource {}", (Object)provider, (Object)resource);
        try (InputStream thumbnailIs = provider.getThumbnail(resource);){
            InputStream inputStream = thumbnailIs;
            for (TransformationHandlerConfig config : transformation.getHandlers()) {
                log.debug("Handling command: {}", (Object)config);
                TransformationHandler handler = this.getTransformationHandler(config.getHandlerType());
                if (handler != null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    log.debug("Invoking handler {} for command {}", (Object)handler.getClass().getCanonicalName(), (Object)config.getHandlerType());
                    handler.handle(inputStream, outputStream, config);
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    continue;
                }
                log.info("No handler found for: {}", (Object)config.getHandlerType());
            }
            if (!this.getMetaType(resource).equals(format.getMimeType())) {
                log.debug("Converting to {}", (Object)format);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
                builder.outputFormat(format.toString());
                builder.scale(1.0);
                builder.toOutputStream((OutputStream)baos);
                inputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
    }
}

