/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hamcrest.matchers;

import org.apache.sling.api.resource.Resource;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ResourceTypeMatcher
extends TypeSafeMatcher<Resource> {
    private final String type;
    private final boolean allowSubtypes;

    public ResourceTypeMatcher(String type, boolean allowSubtypes) {
        this.type = type;
        this.allowSubtypes = allowSubtypes;
    }

    public void describeTo(Description description) {
        description.appendText("Resource with type ").appendValue((Object)this.type);
    }

    protected boolean matchesSafely(Resource resource) {
        if (this.allowSubtypes) {
            return resource.isResourceType(this.type);
        }
        return this.type.equals(resource.getResourceType());
    }

    protected void describeMismatchSafely(Resource resource, Description mismatchDescription) {
        mismatchDescription.appendText("was Resource with type ").appendValue((Object)resource.getResourceType()).appendText(" (resource: ").appendValue((Object)resource).appendText(")");
    }
}

