/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.CommandException;
import org.subethamail.smtp.server.CommandRegistry;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.InvalidCommandNameException;
import org.subethamail.smtp.server.UnknownCommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandler {
    private Map<String, Command> commandMap = new HashMap<String, Command>();
    private static Log log = LogFactory.getLog(CommandHandler.class);

    public CommandHandler() {
        for (CommandRegistry registry : CommandRegistry.values()) {
            this.addCommand(registry.getCommand());
        }
    }

    public CommandHandler(Collection<Command> availableCommands) {
        for (Command command : availableCommands) {
            this.addCommand(command);
        }
    }

    public void addCommand(Command command) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added command: " + command.getName()));
        }
        this.commandMap.put(command.getName(), command);
    }

    public boolean containsCommand(String command) {
        return this.commandMap.containsKey(command);
    }

    public void handleCommand(ConnectionContext context, String commandString) throws SocketTimeoutException, IOException {
        try {
            Command command = this.getCommandFromString(commandString);
            command.execute(commandString, context);
        }
        catch (CommandException e) {
            context.sendResponse("500 " + e.getMessage());
        }
    }

    private Command getCommandFromString(String commandString) throws UnknownCommandException, InvalidCommandNameException {
        String verb;
        Command command = null;
        String key = this.toKey(commandString);
        if (key != null) {
            command = this.commandMap.get(key);
        }
        if (command == null && (verb = this.toVerb(commandString)) != null) {
            command = this.commandMap.get(verb);
        }
        if (command == null) {
            throw new UnknownCommandException("Error: command not implemented");
        }
        return command;
    }

    private String toKey(String string) throws InvalidCommandNameException {
        if (string == null || string.length() < 4) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return string.substring(0, 4).toUpperCase();
    }

    private String toVerb(String string) throws InvalidCommandNameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return stringTokenizer.nextToken().toUpperCase();
    }
}

