/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class UnwrapPlugin
extends AbstractPlugin {
    public UnwrapPlugin() {
        this.name = "unwrap";
        this.priority = 125;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private Command unwrapTest;
            private boolean isSlyTag = false;
            private String identifierName = UnwrapPlugin.this.decodeVariableName(callInfo);
            private boolean globalBinding;

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                boolean bl = this.globalBinding = this.identifierName != null;
                if (this.identifierName == null) {
                    this.identifierName = compilerContext.generateVariable("unwrapCondition");
                }
                if (this.globalBinding) {
                    stream.write(new VariableBinding.Global(this.identifierName, expression.getRoot()));
                } else {
                    stream.write(new VariableBinding.Start(this.identifierName, this.testNode()));
                }
                this.isSlyTag = "sly".equals(tagName.toLowerCase());
                this.unwrapTest = new Conditional.Start(this.identifierName, false);
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.write(this.unwrapTest);
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                stream.write(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.write(this.unwrapTest);
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.write(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void afterElement(PushStream stream) {
                if (!this.globalBinding) {
                    stream.write(VariableBinding.END);
                }
            }

            private ExpressionNode testNode() {
                return this.isEmptyExpression(expression.getRoot()) ? BooleanConstant.TRUE : expression.getRoot();
            }

            private boolean isEmptyExpression(ExpressionNode node) {
                return node instanceof StringConstant && ((StringConstant)node).getText().isEmpty();
            }
        };
    }
}

