/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class TextPlugin
extends AbstractPlugin {
    public TextPlugin() {
        this.name = "text";
        this.priority = 9;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){

            @Override
            public void beforeChildren(PushStream stream) {
                String variable = compilerContext.generateVariable("textContent");
                stream.write(new VariableBinding.Start(variable, TextPlugin.this.adjustContext(compilerContext, expression, MarkupContext.TEXT, ExpressionContext.TEXT).getRoot()));
                stream.write(new OutputVariable(variable));
                stream.write(VariableBinding.END);
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterChildren(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }
        };
    }

    private Expression adjustContext(CompilerContext compilerContext, Expression expression, MarkupContext markupContext, ExpressionContext expressionContext) {
        RuntimeCall runtimeCall;
        ExpressionNode root = expression.getRoot();
        if (root instanceof RuntimeCall && (runtimeCall = (RuntimeCall)root).getFunctionName().equals("xss")) {
            return expression;
        }
        return compilerContext.adjustToContext(expression, markupContext, expressionContext);
    }
}

