/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;

public class FormatFilter
extends AbstractFilter {
    public static final String FORMAT_OPTION = "format";
    public static final String TYPE_OPTION = "type";
    public static final String TIMEZONE_OPTION = "timezone";

    private FormatFilter() {
        super(NON_PARAMETRIZABLE_CONTEXTS, new HashSet<String>(Arrays.asList(FORMAT_OPTION, TYPE_OPTION, "locale", TIMEZONE_OPTION)), Collections.singleton(FORMAT_OPTION));
    }

    public static FormatFilter getInstance() {
        return FormatFilterLoader.INSTANCE;
    }

    @Override
    protected Expression apply(Expression expression, Map<String, ExpressionNode> options) {
        RuntimeCall translation = new RuntimeCall(FORMAT_OPTION, expression.getRoot(), new MapLiteral(options));
        return expression.withNode(translation);
    }

    private static final class FormatFilterLoader {
        private static final FormatFilter INSTANCE = new FormatFilter();

        private FormatFilterLoader() {
        }
    }
}

