/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;

public abstract class AbstractFilter
implements Filter {
    protected int priority = 100;
    public static final Set<ExpressionContext> NON_PARAMETRIZABLE_CONTEXTS;
    private final Set<ExpressionContext> applicableContexts;
    private final Set<String> options;
    private final Set<String> requiredOptions;

    AbstractFilter(Set<ExpressionContext> applicableContexts, Set<String> options, Set<String> requiredOptions) {
        this.applicableContexts = applicableContexts;
        this.options = options;
        this.requiredOptions = requiredOptions;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int compareTo(Filter o) {
        if (this.priority < o.priority()) {
            return -1;
        }
        if (this.priority == o.priority()) {
            return 0;
        }
        return 1;
    }

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        Set<String> expressionOptions = expression.getOptions().keySet();
        if (this.getApplicableContexts().contains((Object)expressionContext) && expressionOptions.containsAll(this.getRequiredOptions())) {
            return this.apply(expression, this.getFilterOptions(expression, this.getOptions()));
        }
        return expression;
    }

    protected abstract Expression apply(Expression var1, Map<String, ExpressionNode> var2);

    private Map<String, ExpressionNode> getFilterOptions(Expression expression, Set<String> options) {
        HashMap<String, ExpressionNode> collector = new HashMap<String, ExpressionNode>();
        for (String option : options) {
            ExpressionNode optionNode = expression.removeOption(option);
            if (optionNode == null) continue;
            collector.put(option, optionNode);
        }
        return collector;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    @Override
    public Set<String> getOptions() {
        return this.options;
    }

    @Override
    public Set<String> getRequiredOptions() {
        return this.requiredOptions;
    }

    @Override
    public Set<ExpressionContext> getApplicableContexts() {
        return this.applicableContexts;
    }

    static {
        HashSet<ExpressionContext> contexts = new HashSet<ExpressionContext>(Arrays.asList(ExpressionContext.values()));
        contexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_USE);
        contexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE);
        contexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_CALL);
        NON_PARAMETRIZABLE_CONTEXTS = Collections.unmodifiableSet(contexts);
    }
}

