/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.commands;

import java.util.Stack;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.UniformVisitor;

public final class StatefulVisitor
implements CommandVisitor {
    private final Stack<CommandVisitor> stack = new Stack();
    private CommandVisitor visitor;
    private StateControl control = new StateControl();

    public StatefulVisitor() {
        this.visitor = InvalidState.INSTANCE;
    }

    public StateControl getControl() {
        return this.control;
    }

    public void initializeWith(CommandVisitor initialState) {
        if (this.visitor != InvalidState.INSTANCE) {
            throw new IllegalStateException("Initial state is already set");
        }
        this.visitor = initialState;
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        this.visitor.visit(conditionalStart);
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
        this.visitor.visit(conditionalEnd);
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.visitor.visit(variableBindingStart);
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
        this.visitor.visit(variableBindingEnd);
    }

    @Override
    public void visit(VariableBinding.Global globalAssignment) {
        this.visitor.visit(globalAssignment);
    }

    @Override
    public void visit(OutputVariable outputVariable) {
        this.visitor.visit(outputVariable);
    }

    @Override
    public void visit(OutText outText) {
        this.visitor.visit(outText);
    }

    @Override
    public void visit(Loop.Start loopStart) {
        this.visitor.visit(loopStart);
    }

    @Override
    public void visit(Loop.End loopEnd) {
        this.visitor.visit(loopEnd);
    }

    @Override
    public void visit(Procedure.Start startProcedure) {
        this.visitor.visit(startProcedure);
    }

    @Override
    public void visit(Procedure.End endProcedure) {
        this.visitor.visit(endProcedure);
    }

    @Override
    public void visit(Procedure.Call procedureCall) {
        this.visitor.visit(procedureCall);
    }

    private void pushVisitor(CommandVisitor visitor) {
        this.stack.push(this.visitor);
        this.visitor = visitor;
    }

    private CommandVisitor popVisitor() {
        CommandVisitor top = this.visitor;
        this.visitor = this.stack.pop();
        return top;
    }

    private static final class InvalidState
    extends UniformVisitor {
        public static final InvalidState INSTANCE = new InvalidState();

        private InvalidState() {
        }

        @Override
        public void onCommand(Command command) {
            throw new IllegalStateException("StatefulVisitor has not been initialized");
        }
    }

    public final class StateControl {
        public void push(CommandVisitor visitor) {
            StatefulVisitor.this.pushVisitor(visitor);
        }

        public CommandVisitor pop() {
            return StatefulVisitor.this.popVisitor();
        }

        public CommandVisitor replace(CommandVisitor visitor) {
            CommandVisitor current = this.pop();
            this.push(visitor);
            return current;
        }
    }
}

