/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.resourcemerger.impl.MergedValueMap;

public class MergedResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final String path;
    private final String resourceType;
    private final String resourceSuperType;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private final ValueMap properties;
    private final List<Resource> mergedResources;

    MergedResource(ResourceResolver resolver, String mergeRootPath, String relativePath, List<Resource> mergedResources, List<ValueMap> valueMaps) {
        this.resolver = resolver;
        this.path = relativePath.length() == 0 ? mergeRootPath : mergeRootPath + "/" + relativePath;
        this.mergedResources = mergedResources;
        this.properties = new DeepReadValueMapDecorator((Resource)this, (ValueMap)new MergedValueMap(valueMaps));
        this.resourceType = this.detectResourceType(relativePath);
        this.resourceSuperType = this.detectResourceSuperType();
        this.metadata.put("sling.mergedResource", (Object)true);
        String[] resourcePaths = new String[mergedResources.size()];
        int i = 0;
        for (Resource rsrc : mergedResources) {
            resourcePaths[i] = rsrc.getPath();
            ++i;
        }
        this.metadata.put("sling.mergedResources", (Object)resourcePaths);
    }

    private String detectResourceType(String relativePath) {
        String type = this.mergedResources.get(this.mergedResources.size() - 1).getResourceType();
        if (type == null) {
            type = relativePath.length() == 0 ? "/" : relativePath;
        }
        return type;
    }

    private String detectResourceSuperType() {
        String type = (String)this.properties.get("sling:resourceType", String.class);
        if (type != null && !type.equals(this.resourceType)) {
            return type;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public List<Resource> getMergedResources() {
        return this.mergedResources;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.properties;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Resource r = (Resource)o;
        return r.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        Object resources = this.metadata.get((Object)"sling.mergedResources");
        return "MergedResource [path=" + this.path + ", resources=" + (resources instanceof String[] ? Arrays.toString((String[])resources) : resources.toString()) + "]";
    }
}

