/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal.inputstream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.AbstractInputStreamPipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvPipe
extends AbstractInputStreamPipe {
    private static Logger logger = LoggerFactory.getLogger(CsvPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/csv";
    protected static final String PN_SEPARATOR = "separator";
    protected static final String DEFAULT_SEPARATOR = ",";
    BufferedReader reader;
    String nextLine = null;
    int index = 0;

    public CsvPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    @Override
    public Iterator<Resource> getOutput(InputStream inputStream) {
        Iterator output = EMPTY_ITERATOR;
        final String separator = (String)this.properties.get(PN_SEPARATOR, (Object)DEFAULT_SEPARATOR);
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            String headersLine = this.reader.readLine();
            final String[] headers = headersLine.split(separator);
            if (headers.length > 0) {
                this.nextLine = this.reader.readLine();
                final Resource inputResource = this.getInput();
                output = new Iterator<Resource>(){

                    @Override
                    public boolean hasNext() {
                        return StringUtils.isNotBlank((CharSequence)CsvPipe.this.nextLine);
                    }

                    @Override
                    public Resource next() {
                        try {
                            String[] values = CsvPipe.this.nextLine.split(separator);
                            if (values.length < headers.length) {
                                throw new IllegalArgumentException("wrong format line " + CsvPipe.this.index + " should have at least the same number of columns than the headers");
                            }
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (int i = 0; i < headers.length; ++i) {
                                map.put(headers[i], values[i]);
                            }
                            CsvPipe.this.binding = map;
                            CsvPipe.this.nextLine = CsvPipe.this.reader.readLine();
                        }
                        catch (IOException e) {
                            logger.error("Unable to retrieve {}nth line of csv file", (Object)CsvPipe.this.index, (Object)e);
                            CsvPipe.this.nextLine = null;
                            throw new NoSuchElementException();
                        }
                        return inputResource;
                    }
                };
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return output;
    }
}

