/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.JexlNode;

public class Closure
extends Script {
    protected final Scope.Frame frame;

    protected Closure(Interpreter theCaller, ASTJexlLambda lambda) {
        super(theCaller.jexl, null, lambda);
        this.frame = lambda.createFrame(theCaller.frame, new Object[0]);
    }

    @Override
    public String toString() {
        return this.getParsedText();
    }

    @Override
    public String getParsedText() {
        Debugger debug = new Debugger();
        debug.debug(this.script, false);
        return debug.toString();
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.jexl != null ? this.jexl.hashCode() : 0);
        hash = 31 * hash + (this.source != null ? this.source.hashCode() : 0);
        hash = 31 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Closure other = (Closure)obj;
        if (this.jexl != other.jexl) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.frame == other.frame || this.frame != null && this.frame.equals(other.frame);
    }

    public void setHoisted(int symbol, Object value) {
        Integer reg;
        ASTJexlLambda lambda;
        Scope scope;
        if (this.script instanceof ASTJexlLambda && (scope = (lambda = (ASTJexlLambda)this.script).getScope()) != null && (reg = scope.getHoisted(symbol)) != null) {
            this.frame.set(reg, value);
        }
    }

    @Override
    public Object evaluate(JexlContext context) {
        return this.execute(context, null);
    }

    @Override
    public Object execute(JexlContext context) {
        return this.execute(context, null);
    }

    @Override
    public Object execute(JexlContext context, Object ... args) {
        Scope.Frame callFrame = null;
        if (this.frame != null) {
            callFrame = this.frame.assign(args);
        }
        Interpreter interpreter = this.jexl.createInterpreter(context, callFrame);
        JexlNode block = this.script.jjtGetChild(this.script.jjtGetNumChildren() - 1);
        return interpreter.interpret(block);
    }

    @Override
    public Callable<Object> callable(JexlContext context, Object ... args) {
        Scope.Frame local = null;
        if (this.frame != null) {
            local = this.frame.assign(args);
        }
        final Interpreter interpreter = this.jexl.createInterpreter(context, local);
        return new Callable<Object>(){
            private Object result;
            {
                this.result = interpreter;
            }

            @Override
            public Object call() throws Exception {
                if (this.result == interpreter) {
                    JexlNode block = Closure.this.script.jjtGetChild(Closure.this.script.jjtGetNumChildren() - 1);
                    this.result = interpreter.interpret(block);
                }
                return this.result;
            }
        };
    }
}

