/*
 * Decompiled with CFR 0.152.
 */
package slingmodelsimpl.org.apache.sling.scripting.core.impl.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.apache.sling.api.scripting.LazyBindings;
import org.jetbrains.annotations.NotNull;

public class ProtectedBindings
extends LazyBindings {
    private static final long serialVersionUID = -5988579857015221345L;
    private final Bindings wrapped;
    private final Set<String> protectedKeys;

    public ProtectedBindings(Bindings wrapped, Set<String> protectedKeys) {
        this.wrapped = wrapped;
        this.protectedKeys = protectedKeys;
    }

    public Object put(String key, Object value) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            String key = entry.getKey();
            if (this.protectedKeys.contains(key)) continue;
            this.wrapped.put(key, entry.getValue());
        }
    }

    public Object remove(Object key) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.remove(key);
    }

    public void clear() {
        throw new UnsupportedOperationException("ProtectedBindings does not support clear()");
    }

    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.wrapped.entrySet());
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @NotNull
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.wrapped.keySet());
    }

    public int size() {
        return this.wrapped.size();
    }

    @NotNull
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.wrapped.values());
    }

    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    public Object get(Object key) {
        return this.wrapped.get(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.protectedKeys == null ? 0 : this.protectedKeys.hashCode());
        result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ProtectedBindings other = (ProtectedBindings)((Object)obj);
        if (this.protectedKeys == null ? other.protectedKeys != null : !this.protectedKeys.equals(other.protectedKeys)) {
            return false;
        }
        return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
    }
}

