/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.rules.ServerSideTeleporter;
import org.junit.rules.ExternalResource;

public abstract class TeleporterRule
extends ExternalResource {
    protected Class<?> classUnderTest;
    public static final String CLIENT_CLASS = "org.apache.sling.testing.teleporter.client.ClientSideTeleporter";
    public static final String CUSTOMIZER_PATTERN = "org.apache.sling.junit.teleporter.customizers.<NAME>Customizer";
    private static final String DEFAULT_CUSTOMIZER_CLASS = "org.apache.sling.testing.teleporter.client.DefaultPropertyBasedCustomizer";
    private String clientSetupOptions;
    protected List<String> embeddedResourcePaths = new ArrayList<String>();

    protected TeleporterRule() {
    }

    protected void setClassUnderTest(Class<?> c) {
        this.classUnderTest = c;
    }

    public static boolean isServerSide() {
        return Activator.getBundleContext() != null;
    }

    public static TeleporterRule forClass(Class<?> classUnderTest) {
        return TeleporterRule.forClass(classUnderTest, null);
    }

    public static TeleporterRule forClass(Class<?> classUnderTest, String clientSetupOptions) {
        TeleporterRule result = null;
        if (TeleporterRule.isServerSide()) {
            result = new ServerSideTeleporter(classUnderTest);
        } else {
            try {
                result = TeleporterRule.createInstance(TeleporterRule.class, CLIENT_CLASS);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate Teleporter client org.apache.sling.testing.teleporter.client.ClientSideTeleporter", e);
            }
        }
        result.clientSetupOptions = clientSetupOptions;
        result.setClassUnderTest(classUnderTest);
        return result;
    }

    protected void customize() {
        if (!TeleporterRule.isServerSide()) {
            if (this.clientSetupOptions != null && !this.clientSetupOptions.isEmpty()) {
                String customizerClassName = this.clientSetupOptions;
                String customizerOptions = "";
                int firstColon = this.clientSetupOptions.indexOf(":");
                if (firstColon > 0) {
                    customizerClassName = this.clientSetupOptions.substring(0, firstColon);
                    customizerOptions = this.clientSetupOptions.substring(firstColon + 1);
                }
                if (!customizerClassName.contains(".")) {
                    customizerClassName = CUSTOMIZER_PATTERN.replace("<NAME>", customizerClassName);
                }
                TeleporterRule.createInstance(Customizer.class, customizerClassName).customize(this, customizerOptions);
            } else {
                TeleporterRule.createInstance(Customizer.class, DEFAULT_CUSTOMIZER_CLASS).customize(this, null);
            }
        }
    }

    protected static <T> T createInstance(Class<T> objectClass, String className) {
        try {
            return (T)TeleporterRule.class.getClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + className, e);
        }
    }

    public final <T> T getService(Class<T> serviceClass) {
        return this.getService(serviceClass, null);
    }

    public <T> T getService(Class<T> serviceClass, String ldapFilter) {
        throw new UnsupportedOperationException("This TeleporterRule does not implement getService()");
    }

    public TeleporterRule withResources(String ... paths) {
        for (String path : paths) {
            this.embeddedResourcePaths.add(path);
        }
        return this;
    }

    public static interface Customizer {
        public void customize(TeleporterRule var1, String var2);
    }
}

