/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.jupiter.osgi.impl;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.sling.junit.jupiter.osgi.impl.ReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public abstract class AbstractTypeBasedParameterResolver
implements ParameterResolver {
    protected abstract boolean supportsParameter(@NotNull ParameterContext var1, @NotNull ExtensionContext var2, @NotNull Type var3);

    protected abstract Object resolveParameter(@NotNull ParameterContext var1, @NotNull ExtensionContext var2, @NotNull Type var3);

    public final boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Type type = AbstractTypeBasedParameterResolver.getTypeOfParameter(parameterContext, extensionContext);
        return this.supportsParameter(parameterContext, extensionContext, type);
    }

    public final Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Type typeOfParameter = AbstractTypeBasedParameterResolver.getTypeOfParameter(parameterContext, extensionContext);
        return this.resolveParameter(parameterContext, extensionContext, typeOfParameter);
    }

    @NotNull
    private static Type getTypeOfParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Type type = parameterContext.getParameter().getParameterizedType();
        if (type instanceof TypeVariable) {
            Map<TypeVariable<?>, Type> typeVariableTypeMap = ReflectionHelper.determineTypeArguments(extensionContext.getRequiredTestClass());
            return typeVariableTypeMap.getOrDefault(type, type);
        }
        return type;
    }
}

