/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jmx.provider.impl;

import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jmx.provider.impl.AttributeResource;
import org.apache.sling.jmx.provider.impl.AttributesResource;
import org.apache.sling.jmx.provider.impl.MBeanResource;
import org.apache.sling.jmx.provider.impl.MapResource;
import org.apache.sling.jmx.provider.impl.RootResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Apache Sling JMX Resource Provider", description="This provider mounts JMX mbeans into the resource tree.")
@Service(value={ResourceProvider.class})
@Properties(value={@Property(name="provider.roots", value={"/system/sling/monitoring/mbeans"}, label="Root", description="The mount point of the JMX beans"), @Property(name="provider.useResourceAccessSecurity", boolValue={true}, propertyPrivate=true), @Property(name="provider.ownsRoots", boolValue={true}, propertyPrivate=true)})
public class JMXResourceProvider
implements ResourceProvider {
    private String[] rootsWithSlash;
    private String[] roots;
    private MBeanServer mbeanServer;
    private static final String MARKER_NOTYPE = "{notype}";
    private static final String MARKER_NONAME = "{noname}";

    @Activate
    protected void activate(Map<String, Object> props) {
        String[] paths = PropertiesUtil.toStringArray((Object)props.get("provider.roots"));
        ArrayList<String> rootsList = new ArrayList<String>();
        ArrayList<String> rootsWithSlashList = new ArrayList<String>();
        if (paths != null) {
            for (String p : paths) {
                if (p.length() <= 0) continue;
                if (p.endsWith("/")) {
                    rootsList.add(p.substring(0, p.length() - 1));
                    rootsWithSlashList.add(p);
                    continue;
                }
                rootsList.add(p);
                rootsWithSlashList.add(p + "/");
            }
        }
        this.rootsWithSlash = rootsWithSlashList.toArray(new String[rootsWithSlashList.size()]);
        this.roots = rootsList.toArray(new String[rootsList.size()]);
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @Deactivate
    protected void deactivate() {
        this.mbeanServer = null;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        PathInfo info = this.parse(path);
        if (info != null) {
            if (info.isRoot) {
                return new RootResource(resourceResolver, path);
            }
            if (info.mbeanInfo == null) {
                Set<ObjectName> names = this.queryObjectNames(info.pathInfo);
                if (names.size() != 0) {
                    return new RootResource(resourceResolver, path);
                }
            } else {
                if (info.pathInfo == null) {
                    return new MBeanResource(this.mbeanServer, resourceResolver, this.convertObjectNameToResourcePath(info.objectName), path, info.mbeanInfo, info.objectName);
                }
                if (info.pathInfo.equals("mbean:attributes")) {
                    MBeanResource parent = (MBeanResource)this.getResource(resourceResolver, ResourceUtil.getParent((String)path));
                    return new AttributesResource(resourceResolver, path, parent);
                }
                if (info.pathInfo.startsWith("mbean:attributes/")) {
                    String subPath;
                    String attrName;
                    MBeanResource parentMBeanResource;
                    AttributesResource parentAttributesResource;
                    Resource parentRsrc = this.getResource(resourceResolver, ResourceUtil.getParent((String)path));
                    if (parentRsrc instanceof AttributesResource) {
                        parentAttributesResource = (AttributesResource)parentRsrc;
                        parentMBeanResource = (MBeanResource)parentRsrc.getParent();
                    } else {
                        AttributeResource parent = parentRsrc instanceof AttributeResource ? (AttributeResource)parentRsrc : ((MapResource)parentRsrc).getAttributeResource();
                        parentAttributesResource = (AttributesResource)parent.getParent();
                        parentMBeanResource = (MBeanResource)parentAttributesResource.getParent();
                    }
                    AttributeList result = parentMBeanResource.getAttributes();
                    String attrPath = info.pathInfo.substring("mbean:attributes/".length());
                    int pos = attrPath.indexOf(47);
                    if (pos == -1) {
                        attrName = attrPath;
                        subPath = null;
                    } else {
                        attrName = attrPath.substring(0, pos);
                        subPath = attrPath.substring(pos + 1);
                    }
                    for (MBeanAttributeInfo mai : info.mbeanInfo.getAttributes()) {
                        if (!mai.getName().equals(attrName)) continue;
                        Iterator iter = result.iterator();
                        Object value = null;
                        while (iter.hasNext() && value == null) {
                            Attribute a = (Attribute)iter.next();
                            if (!a.getName().equals(attrName)) continue;
                            value = a.getValue();
                        }
                        AttributeResource rsrc = new AttributeResource(resourceResolver, path, mai, value, parentAttributesResource);
                        if (subPath != null) {
                            return rsrc.getChildResource(subPath);
                        }
                        return rsrc;
                    }
                }
            }
        }
        return null;
    }

    private Set<ObjectName> queryObjectNames(String prefix) {
        Set<ObjectName> allNames;
        Set<ObjectName> names = allNames = this.mbeanServer.queryNames(null, null);
        if (prefix != null) {
            String pathPrefix = prefix + '/';
            names = new HashSet<ObjectName>();
            for (ObjectName name : allNames) {
                String path = this.convertObjectNameToResourcePath(name);
                if (!path.startsWith(pathPrefix)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public Iterator<Resource> listChildren(final Resource parent) {
        PathInfo info = this.parse(parent.getPath());
        if (info != null) {
            if (info.isRoot || info.mbeanInfo == null) {
                Set<ObjectName> names = this.queryObjectNames(info.isRoot ? null : info.pathInfo);
                HashSet<String> filteredNames = new HashSet<String>();
                String prefix = info.isRoot ? null : info.pathInfo + "/";
                for (ObjectName name : names) {
                    String path = this.convertObjectNameToResourcePath(name);
                    String testName = info.isRoot ? path : path.substring(prefix.length());
                    int sep = testName.indexOf(47);
                    if (sep == -1) {
                        filteredNames.add(":" + name.getCanonicalName());
                        continue;
                    }
                    filteredNames.add(testName.substring(0, sep));
                }
                ArrayList sortedNames = new ArrayList(filteredNames);
                Collections.sort(sortedNames);
                final Iterator iter = sortedNames.iterator();
                return new Iterator<Resource>(){
                    private Resource next;
                    {
                        this.seek();
                    }

                    private void seek() {
                        while (iter.hasNext() && this.next == null) {
                            String name = (String)iter.next();
                            if (name.startsWith(":")) {
                                try {
                                    ObjectName on = new ObjectName(name.substring(1));
                                    MBeanInfo info = JMXResourceProvider.this.mbeanServer.getMBeanInfo(on);
                                    String path = JMXResourceProvider.this.convertObjectNameToResourcePath(on);
                                    int sep = path.lastIndexOf(47);
                                    this.next = new MBeanResource(JMXResourceProvider.this.mbeanServer, parent.getResourceResolver(), path, parent.getPath() + "/" + path.substring(sep + 1), info, on);
                                }
                                catch (IntrospectionException e) {
                                }
                                catch (InstanceNotFoundException e) {
                                }
                                catch (ReflectionException e) {
                                }
                                catch (MalformedObjectNameException malformedObjectNameException) {}
                                continue;
                            }
                            this.next = new RootResource(parent.getResourceResolver(), parent.getPath() + '/' + name);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Resource next() {
                        if (this.next != null) {
                            Resource rsrc = this.next;
                            this.next = null;
                            this.seek();
                            return rsrc;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
            if (info.pathInfo == null) {
                MBeanResource parentResource = parent instanceof MBeanResource ? (MBeanResource)parent : (MBeanResource)this.getResource(parent.getResourceResolver(), parent.getPath());
                ArrayList<AttributesResource> list = new ArrayList<AttributesResource>();
                list.add(new AttributesResource(parent.getResourceResolver(), parent.getPath() + "/mbean:attributes", parentResource));
                return list.iterator();
            }
            if (info.pathInfo.equals("mbean:attributes")) {
                final AttributesResource parentResource = parent instanceof AttributesResource ? (AttributesResource)parent : (AttributesResource)this.getResource(parent.getResourceResolver(), parent.getPath());
                MBeanResource parentMBeanResource = (MBeanResource)parentResource.getParent();
                AttributeList result = parentMBeanResource.getAttributes();
                MBeanAttributeInfo[] infos = info.mbeanInfo.getAttributes();
                final HashMap<String, MBeanAttributeInfo> infoMap = new HashMap<String, MBeanAttributeInfo>();
                for (MBeanAttributeInfo i : infos) {
                    infoMap.put(i.getName(), i);
                }
                final Iterator iter = result.iterator();
                return new Iterator<Resource>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public Resource next() {
                        Attribute attr = (Attribute)iter.next();
                        return new AttributeResource(parent.getResourceResolver(), parent.getPath() + "/" + attr.getName(), (MBeanAttributeInfo)infoMap.get(attr.getName()), attr.getValue(), parentResource);
                    }

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }
                };
            }
            if (info.pathInfo.startsWith("mbean:attributes/")) {
                Resource checkParentResource = parent;
                if (!(checkParentResource instanceof AttributeResource) && !(checkParentResource instanceof MapResource)) {
                    checkParentResource = this.getResource(parent.getResourceResolver(), parent.getPath());
                }
                AttributeResource parentResource = checkParentResource instanceof AttributeResource ? (AttributeResource)checkParentResource : ((MapResource)checkParentResource).getAttributeResource();
                String attrPath = info.pathInfo.substring("mbean:attributes/".length());
                int pos = attrPath.indexOf(47);
                String subPath = pos == -1 ? null : attrPath.substring(pos + 1);
                return parentResource.getChildren(parent.getPath(), subPath);
            }
        }
        return null;
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return value;
        }
    }

    private String decode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return value;
        }
    }

    private String convertObjectNameToResourcePath(ObjectName name) {
        StringBuilder sb = new StringBuilder(name.getDomain().replace('.', '/'));
        sb.append('/');
        if (name.getKeyProperty("type") != null) {
            sb.append(this.encode(name.getKeyProperty("type")));
        } else {
            sb.append(MARKER_NOTYPE);
        }
        sb.append('/');
        if (name.getKeyProperty("name") != null) {
            sb.append(this.encode(name.getKeyProperty("name")));
        } else {
            sb.append(MARKER_NONAME);
        }
        TreeMap<String, String> props = new TreeMap<String, String>(name.getKeyPropertyList());
        props.remove("name");
        props.remove("type");
        boolean first = true;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (first) {
                first = false;
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(this.encode(entry.getKey()));
            sb.append('=');
            sb.append(this.encode(entry.getValue()));
        }
        return sb.toString();
    }

    private ObjectName convertResourcePathToObjectName(String path) {
        int typeSlash;
        int nameSlash = path.lastIndexOf(47);
        if (nameSlash != -1 && (typeSlash = path.lastIndexOf(47, nameSlash - 1)) != -1) {
            String props;
            String name;
            String domain = path.substring(0, typeSlash).replace('/', '.');
            String type = this.decode(path.substring(typeSlash + 1, nameSlash));
            String nameAndProps = path.substring(nameSlash + 1);
            int colonPos = nameAndProps.indexOf(58);
            if (colonPos == -1) {
                name = this.decode(nameAndProps);
                props = null;
            } else {
                name = this.decode(nameAndProps.substring(0, colonPos));
                props = nameAndProps.substring(colonPos + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(domain);
            sb.append(':');
            boolean hasProps = false;
            if (!MARKER_NOTYPE.equals(type)) {
                sb.append("type=");
                sb.append(type);
                hasProps = true;
            }
            if (!MARKER_NONAME.equals(name)) {
                if (hasProps) {
                    sb.append(",");
                }
                sb.append("name=");
                sb.append(name);
                hasProps = true;
            }
            if (props != null) {
                String[] propArray;
                for (String keyValue : propArray = props.split(",")) {
                    int pos;
                    if (hasProps) {
                        sb.append(",");
                    }
                    if ((pos = keyValue.indexOf(61)) == -1) {
                        return null;
                    }
                    sb.append(this.decode(keyValue.substring(0, pos)));
                    sb.append('=');
                    sb.append(this.decode(keyValue.substring(pos + 1)));
                }
            }
            try {
                return new ObjectName(sb.toString());
            }
            catch (MalformedObjectNameException e) {
                // empty catch block
            }
        }
        return null;
    }

    private PathInfo parse(String path) {
        for (String root : this.rootsWithSlash) {
            if (!path.startsWith(root)) continue;
            String subPath = path.substring(root.length());
            if (subPath.length() == 0) {
                return new PathInfo(true);
            }
            String checkPath = subPath;
            String pathInfo = null;
            ObjectName objectName = null;
            MBeanInfo mbi = null;
            while (checkPath.length() > 0 && mbi == null) {
                try {
                    objectName = this.convertResourcePathToObjectName(checkPath);
                    if (objectName != null) {
                        mbi = this.mbeanServer.getMBeanInfo(objectName);
                    }
                }
                catch (IntrospectionException e) {
                }
                catch (InstanceNotFoundException e) {
                }
                catch (ReflectionException e) {
                    // empty catch block
                }
                if (mbi != null) continue;
                int sep = checkPath.lastIndexOf(47);
                if (sep == -1) {
                    checkPath = "";
                    pathInfo = subPath;
                    continue;
                }
                checkPath = checkPath.substring(0, sep);
                pathInfo = subPath.substring(sep + 1);
            }
            PathInfo info = new PathInfo(pathInfo);
            if (mbi != null) {
                info.objectName = objectName;
                info.mbeanInfo = mbi;
            }
            return info;
        }
        for (String root : this.roots) {
            if (!path.equals(root)) continue;
            return new PathInfo(true);
        }
        return null;
    }

    public static final class PathInfo {
        public final boolean isRoot;
        public final String pathInfo;
        public ObjectName objectName;
        public MBeanInfo mbeanInfo;

        public PathInfo(boolean isRoot) {
            this.isRoot = isRoot;
            this.pathInfo = null;
        }

        public PathInfo(String info) {
            this.isRoot = false;
            this.pathInfo = info;
        }
    }
}

