/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.NamespaceException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.ProgressTracker;

public class JcrNamespaceHelper {
    private static final Logger log = LoggerFactory.getLogger(JcrNamespaceHelper.class);
    private final Session session;
    private final ProgressTracker tracker;

    public JcrNamespaceHelper(@NotNull Session session, @Nullable ProgressTracker tracker) {
        this.session = session;
        this.tracker = tracker;
    }

    public void registerNamespaces(@NotNull Map<String, String> pfxToURI) throws RepositoryException {
        if (!pfxToURI.isEmpty()) {
            Iterator<String> iterator = pfxToURI.keySet().iterator();
            while (iterator.hasNext()) {
                String o;
                String prefix = o = iterator.next();
                String uri = pfxToURI.get(prefix);
                try {
                    this.session.getNamespacePrefix(uri);
                    this.track(this.tracker, "-", prefix + " -> " + uri);
                }
                catch (RepositoryException e) {
                    this.registerNamespace(prefix, uri);
                }
            }
        }
    }

    @NotNull
    public String registerNamespace(@NotNull String pfxHint, @NotNull String uri) throws RepositoryException {
        int i = 0;
        String pfx = pfxHint;
        NamespaceException error = null;
        while (i < 1000) {
            try {
                this.session.getWorkspace().getNamespaceRegistry().registerNamespace(pfx, uri);
                this.track(this.tracker, "A", pfx + " -> " + uri);
                return pfx;
            }
            catch (NamespaceException e) {
                pfx = pfxHint + i++;
                error = e;
            }
        }
        throw new RepositoryException("Giving up automatic namespace registration after 1000 attempts.", error);
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.debug("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }
}

