/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.util;

import java.util.Map;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.util.ldap.LdapAttributeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filters {
    private Filters() {
    }

    public static AttributeFilter ldap(String ldapFilter) {
        return new LdapAttributeFilter(ldapFilter);
    }

    public static AttributeFilter objectClass(Class<?> ... interfaces) {
        StringBuilder filter = new StringBuilder();
        int numClauses = 0;
        for (Class<?> i : interfaces) {
            if (null == i || Object.class == i) continue;
            filter.append("(objectClass=").append(i.getName()).append(')');
            ++numClauses;
        }
        if (0 == numClauses) {
            return null;
        }
        if (1 < numClauses) {
            filter.insert(0, "(&").append(')');
        }
        return new LdapAttributeFilter(filter.toString());
    }

    public static AttributeFilter attributes(final Map<String, ?> sampleAttributes) {
        return new AttributeFilter(){

            @Override
            public boolean matches(Map<String, ?> attributes) {
                return null != attributes && attributes.entrySet().containsAll(sampleAttributes.entrySet());
            }
        };
    }
}

