/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.spi;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.media.markup.DummyImageMediaMarkupBuilder;
import io.wcm.handler.media.markup.SimpleImageMediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaProcessor;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.dam.DamMediaSource;
import io.wcm.sling.commons.caservice.ContextAwareService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class MediaHandlerConfig
implements ContextAwareService {
    public static final double DEFAULT_JPEG_QUALITY = 0.98;
    private static final List<Class<? extends MediaSource>> DEFAULT_MEDIA_SOURCES = ImmutableList.of(DamMediaSource.class);
    private static final List<Class<? extends MediaMarkupBuilder>> DEFAULT_MEDIA_MARKUP_BUILDERS = ImmutableList.of(SimpleImageMediaMarkupBuilder.class, DummyImageMediaMarkupBuilder.class);

    @NotNull
    public List<Class<? extends MediaSource>> getSources() {
        return DEFAULT_MEDIA_SOURCES;
    }

    @NotNull
    public List<Class<? extends MediaMarkupBuilder>> getMarkupBuilders() {
        return DEFAULT_MEDIA_MARKUP_BUILDERS;
    }

    @NotNull
    public List<Class<? extends MediaProcessor>> getPreProcessors() {
        return ImmutableList.of();
    }

    @NotNull
    public List<Class<? extends MediaProcessor>> getPostProcessors() {
        return ImmutableList.of();
    }

    public double getDefaultImageQuality(String mimeType) {
        if (StringUtils.isNotEmpty((CharSequence)mimeType)) {
            String format = StringUtils.substringAfter((String)mimeType.toLowerCase(), (String)"image/");
            if (StringUtils.equals((CharSequence)format, (CharSequence)"jpg") || StringUtils.equals((CharSequence)format, (CharSequence)"jpeg")) {
                return 0.98;
            }
            if (StringUtils.equals((CharSequence)format, (CharSequence)"gif")) {
                return 256.0;
            }
        }
        return 1.0;
    }

    public boolean useAdobeStandardNames() {
        return false;
    }

    @NotNull
    public String getMediaRefProperty() {
        if (this.useAdobeStandardNames()) {
            return "fileReference";
        }
        return "mediaRef";
    }

    @NotNull
    public String getMediaCropProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageCrop";
        }
        return "mediaCrop";
    }

    @NotNull
    public String getMediaRotationProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageRotate";
        }
        return "mediaRotate";
    }

    @NotNull
    public String getMediaMapProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageMap";
        }
        return "mediaMap";
    }

    @NotNull
    public String getMediaAltTextProperty() {
        if (this.useAdobeStandardNames()) {
            return "alt";
        }
        return "mediaAltText";
    }

    @NotNull
    public String getMediaInlineNodeName() {
        if (this.useAdobeStandardNames()) {
            return "file";
        }
        return "mediaInline";
    }

    public boolean includeAssetWebRenditionsByDefault() {
        return true;
    }

    @NotNull
    public String getDamRootPath(@NotNull Page page) {
        return "/content/dam";
    }
}

