/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl.ipeconfig;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class PathParser {
    public static final String NN_ASPECT_RATIOS = "aspectRatios";
    static final String NN_MEDIA_FORMAT = "wcmio:mediaFormat";
    static final String NN_CONFIG = "wcmio:config";
    private static final Pattern PATH_PATTERN = Pattern.compile("^/wcmio:mediaHandler/ipeConfig((/[^/]+)+)/wcmio:mediaFormat((/[^/]+)+)/wcmio:config(/.*)?$");
    private static final Pattern PLUGINS_CROP_PATH_PATTERN = Pattern.compile("^.*/plugins/crop(/aspectRatios(/([^/]+))?)?$");
    private String componentContentPath;
    private String relativeConfigPath;
    private SortedSet<String> mediaFormatNames;
    private boolean pluginsCropNode;
    private boolean aspectRatiosNode;
    private String aspectRatioItemName;

    PathParser(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        if (matcher.matches()) {
            Matcher pluginsCropPathMatcher;
            this.componentContentPath = matcher.group(1);
            String[] names = StringUtils.split((String)matcher.group(3), (String)"/");
            this.mediaFormatNames = new TreeSet<String>(Arrays.asList(names));
            this.relativeConfigPath = matcher.group(5);
            if (StringUtils.isNotEmpty((CharSequence)this.relativeConfigPath) && (pluginsCropPathMatcher = PLUGINS_CROP_PATH_PATTERN.matcher(this.relativeConfigPath)).matches()) {
                if (StringUtils.isEmpty((CharSequence)pluginsCropPathMatcher.group(1))) {
                    this.pluginsCropNode = true;
                } else if (StringUtils.isEmpty((CharSequence)pluginsCropPathMatcher.group(2))) {
                    this.aspectRatiosNode = true;
                } else {
                    this.aspectRatioItemName = pluginsCropPathMatcher.group(3);
                }
            }
        }
    }

    public String getComponentContentPath() {
        return this.componentContentPath;
    }

    public String getRelativeConfigPath() {
        return this.relativeConfigPath;
    }

    public SortedSet<String> getMediaFormatNames() {
        return this.mediaFormatNames;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.componentContentPath);
    }

    public boolean isPluginsCropNode() {
        return this.pluginsCropNode;
    }

    public boolean isAspectRatiosNode() {
        return this.aspectRatiosNode;
    }

    public boolean isAspectRatioItem() {
        return StringUtils.isNotEmpty((CharSequence)this.aspectRatioItemName);
    }

    public String getAspectRatioItemName() {
        return this.aspectRatioItemName;
    }
}

