/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.commons.request.RequestParam;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletResourceTypes(extensions={"json"}, selectors={"wcm-io-handler-media-mediaformat-validate"}, resourceTypes={"sling/servlet/default"}, methods={"GET"})
public final class MediaFormatValidateServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    static final String SELECTOR = "wcm-io-handler-media-mediaformat-validate";
    static final String RP_MEDIA_FORMATS = "mediaFormats";
    static final String RP_MEDIA_FORMATS_MANDATORY = "mediaFormatsMandatory";
    static final String RP_MEDIA_CROPAUTO = "mediaCropAuto";
    static final String RP_MEDIA_REF = "mediaRef";
    public static final String MEDIA_INVALID_REASON_I18N_PREFIX = "io.wcm.handler.media.invalidReason.";
    private static final String ASSET_INVALID_I18N_KEY = "io.wcm.handler.media.assetInvalid";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String[] mediaFormats = StringUtils.split((String)RequestParam.get((ServletRequest)request, (String)RP_MEDIA_FORMATS), (String)",");
        Object[] mediaFormatsMandatory = StringUtils.split((String)RequestParam.get((ServletRequest)request, (String)RP_MEDIA_FORMATS_MANDATORY), (String)",");
        boolean mediaCropAuto = RequestParam.getBoolean((ServletRequest)request, (String)RP_MEDIA_CROPAUTO);
        String mediaRef = RequestParam.get((ServletRequest)request, (String)RP_MEDIA_REF);
        if (mediaFormats == null || mediaFormats.length == 0 || StringUtils.isEmpty((CharSequence)mediaRef)) {
            response.sendError(404);
            return;
        }
        MediaArgs.MediaFormatOption[] mediaFormatOptions = new MediaArgs.MediaFormatOption[mediaFormats.length];
        for (int i = 0; i < mediaFormats.length; ++i) {
            boolean mandatory = false;
            if (mediaFormatsMandatory != null) {
                mandatory = ArrayUtils.contains((Object[])mediaFormatsMandatory, (Object)mediaFormats[i]);
            }
            mediaFormatOptions[i] = new MediaArgs.MediaFormatOption(mediaFormats[i], mandatory);
        }
        MediaHandler mediaHandler = (MediaHandler)AdaptTo.notNull((Adaptable)request, MediaHandler.class);
        Media media = mediaHandler.get(mediaRef).mediaFormatOptions(mediaFormatOptions).autoCrop(mediaCropAuto).build();
        try {
            JSONObject result = new JSONObject();
            result.put("valid", media.isValid());
            if (!media.isValid()) {
                I18n i18n = this.getI18n(request);
                result.put("reason", (Object)this.getI18nText(i18n, MEDIA_INVALID_REASON_I18N_PREFIX + media.getMediaInvalidReason().name()));
                result.put("reasonTitle", (Object)this.getI18nText(i18n, ASSET_INVALID_I18N_KEY));
            }
            response.setContentType(ContentType.JSON);
            response.getWriter().write(result.toString());
        }
        catch (JSONException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private String getI18nText(I18n i18n, String key) {
        try {
            return i18n.get(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    private I18n getI18n(SlingHttpServletRequest request) {
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)request.getResourceResolver(), PageManager.class);
        Page currentPage = pageManager.getContainingPage(request.getResource());
        if (currentPage != null) {
            Locale locale = currentPage.getLanguage(false);
            ResourceBundle resourceBundle = request.getResourceBundle(locale);
            return new I18n(resourceBundle);
        }
        return new I18n((HttpServletRequest)request);
    }
}

