/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionConfiguration;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.resources.impl.common.AbstractModifyingResourceProvider;
import org.apache.sling.distribution.resources.impl.common.SimplePathInfo;

public class DistributionConfigurationResourceProvider
extends AbstractModifyingResourceProvider
implements ResourceProvider,
ModifyingResourceProvider {
    private static final String SETTINGS_RESOURCE_TYPE = "sling/distribution/setting";
    private final DistributionConfigurationManager configurationManager;
    private final DistributionComponentKind kind;

    public DistributionConfigurationResourceProvider(DistributionConfigurationManager configurationManager, String kind, String resourceRoot) {
        super(resourceRoot);
        this.configurationManager = configurationManager;
        this.kind = DistributionComponentKind.fromName(kind);
    }

    @Override
    protected void saveInternalResources(ResourceResolver resourceResolver, Map<String, Map<String, Object>> changedResources, Set<String> deletedResources) throws PersistenceException {
        for (Map.Entry<String, Map<String, Object>> entry : changedResources.entrySet()) {
            String resourceName = entry.getKey();
            Map<String, Object> properties = entry.getValue();
            String componentName = this.getConfigName(resourceName);
            DistributionConfiguration config = new DistributionConfiguration(this.kind, componentName, properties);
            this.configurationManager.saveConfig(resourceResolver, config);
        }
        for (String resourceName : deletedResources) {
            String componentName = this.getConfigName(resourceName);
            this.configurationManager.deleteConfig(resourceResolver, this.kind, componentName);
        }
    }

    @Override
    protected Map<String, Object> getInternalResourceProperties(ResourceResolver resolver, SimplePathInfo pathInfo) {
        String configName;
        DistributionConfiguration config;
        if (pathInfo.isRoot()) {
            return this.getResourceRootProperties(resolver);
        }
        if (pathInfo.isMain()) {
            return this.getResourceProperties(resolver, pathInfo.getMainResourceName());
        }
        if (pathInfo.isChild() && (config = this.configurationManager.getConfig(resolver, this.kind, configName = this.getConfigName(pathInfo.getMainResourceName()))) != null) {
            return this.getChildResourceProperties(config, pathInfo.getChildResourceName());
        }
        return null;
    }

    @Override
    protected Iterable<String> getInternalResourceChildren(ResourceResolver resolver, SimplePathInfo pathInfo) {
        String configName;
        DistributionConfiguration config;
        if (pathInfo.isMain() && (config = this.configurationManager.getConfig(resolver, this.kind, configName = this.getConfigName(pathInfo.getMainResourceName()))) != null) {
            return this.getChildResourceChildren(config, pathInfo.getChildResourceName());
        }
        return null;
    }

    private Map<String, Object> getChildResourceProperties(DistributionConfiguration config, String childResourceName) {
        return null;
    }

    private Iterable<String> getChildResourceChildren(DistributionConfiguration config, String childResourceName) {
        return null;
    }

    private Map<String, Object> getResourceRootProperties(ResourceResolver resolver) {
        List<DistributionConfiguration> configsList = this.configurationManager.getConfigs(resolver, this.kind);
        ArrayList<String> nameList = new ArrayList<String>();
        for (DistributionConfiguration config : configsList) {
            nameList.add(config.getName());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("items", nameList.toArray(new String[nameList.size()]));
        String resourceType = this.getRootResourceType(this.kind);
        result.put("sling:resourceType", resourceType);
        return result;
    }

    private Map<String, Object> getResourceProperties(ResourceResolver resolver, String resourceName) {
        String componentName = this.getConfigName(resourceName);
        DistributionConfiguration config = this.configurationManager.getConfig(resolver, this.kind, componentName);
        if (config != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.putAll(config.getProperties());
            String resourceType = this.getResourceType(this.kind);
            result.put("sling:resourceType", resourceType);
            return result;
        }
        return null;
    }

    private String getConfigName(String configName) {
        return configName;
    }

    private String getResourceType(DistributionComponentKind kind) {
        return SETTINGS_RESOURCE_TYPE;
    }

    private String getRootResourceType(DistributionComponentKind kind) {
        return SETTINGS_RESOURCE_TYPE;
    }
}

