/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueProviderFactory;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionQueueProviderFactory.class}, property={"name=resourceQueue"})
@Designate(ocd=Config.class, factory=true)
public class ResourceQueueProviderFactory
implements DistributionQueueProviderFactory {
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    @Reference
    Scheduler scheduler;
    BundleContext context;
    private boolean isActive;

    @Activate
    protected void activate(BundleContext context, Config conf) {
        this.isActive = conf.queue_isActive();
        this.context = context;
    }

    @Override
    public DistributionQueueProvider getProvider(String agentName, String serviceName) {
        return new ResourceQueueProvider(this.context, this.resourceResolverFactory, serviceName, agentName, this.scheduler, this.isActive);
    }

    @Override
    public void releaseProvider(DistributionQueueProvider queueProvider) {
        if (queueProvider instanceof ResourceQueueProvider) {
            ((ResourceQueueProvider)queueProvider).close();
        }
    }

    @ObjectClassDefinition(name="Apache Sling Resource Queue Provider Factory", description="OSGi configuration factory for Resource-backed queues")
    public static @interface Config {
        @AttributeDefinition(name="Should the Resource-backed queue created with a Queue Processor (i.e., ACTIVE)")
        public boolean queue_isActive() default false;
    }
}

