/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueWrapper;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;

public class CachingDistributionQueue
extends DistributionQueueWrapper {
    private static final int EXPIRY_QUEUE_CACHE = 30000;
    private static final Map<String, DistributionQueueStatus> queueCache = new ConcurrentHashMap<String, DistributionQueueStatus>();
    private static final Map<String, Long> queueCacheExpiry = new ConcurrentHashMap<String, Long>();
    private final String cacheKey;

    public CachingDistributionQueue(String cacheKey, DistributionQueue wrappedQueue) {
        super(wrappedQueue);
        this.cacheKey = cacheKey;
    }

    @Override
    @NotNull
    public DistributionQueueStatus getStatus() {
        DistributionQueueStatus queueStatus = null;
        long now = System.currentTimeMillis();
        Long expiryDate = queueCacheExpiry.get(this.cacheKey);
        if (expiryDate != null && expiryDate < now) {
            queueCache.remove(this.cacheKey);
            queueCacheExpiry.remove(this.cacheKey);
        }
        if ((queueStatus = queueCache.get(this.cacheKey)) != null) {
            return queueStatus;
        }
        queueStatus = this.wrappedQueue.getStatus();
        queueCache.put(this.cacheKey, queueStatus);
        queueCacheExpiry.put(this.cacheKey, System.currentTimeMillis() + 30000L);
        return queueStatus;
    }

    @Override
    @NotNull
    public DistributionQueueType getType() {
        return this.wrappedQueue.getType();
    }

    @Override
    public DistributionQueueEntry add(@NotNull DistributionQueueItem item) {
        queueCache.remove(this.cacheKey);
        queueCacheExpiry.remove(this.cacheKey);
        return super.add(item);
    }

    @Override
    public DistributionQueueEntry remove(@NotNull String itemId) {
        queueCache.remove(this.cacheKey);
        queueCacheExpiry.remove(this.cacheKey);
        return super.remove(itemId);
    }
}

