/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporter;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionPackageExporter.class}, property={"webconsole.configurationFactory.nameHint=Exporter name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class RemoteDistributionPackageExporterFactory
implements DistributionPackageExporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    private DistributionPackageExporter exporter;

    @Activate
    protected void activate(Config conf) {
        this.log.info("activating remote exporter with packagebuilder {} and transportSecretProvider {}", (Object)this.packageBuilder, (Object)this.transportSecretProvider);
        String[] endpoints = conf.endpoints();
        endpoints = SettingsUtils.removeEmptyEntries(endpoints);
        int pollItems = conf.pull_items();
        String exporterName = conf.name();
        DefaultDistributionLog distributionLog = new DefaultDistributionLog(DistributionComponentKind.EXPORTER, exporterName, RemoteDistributionPackageExporter.class, DefaultDistributionLog.LogLevel.ERROR);
        HttpConfiguration httpConfiguration = new HttpConfiguration(10000);
        this.exporter = new RemoteDistributionPackageExporter(distributionLog, this.packageBuilder, this.transportSecretProvider, endpoints, pollItems, httpConfiguration);
    }

    @Deactivate
    protected void deactivate() {
        this.exporter = null;
    }

    @Override
    public void exportPackages(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.exporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String distributionPackageId) throws DistributionException {
        return this.exporter.getPackage(resourceResolver, distributionPackageId);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Exporter - Remote Package Exporter Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the exporter.")
        public String name();

        @AttributeDefinition(cardinality=100, name="Endpoints", description="The list of endpoints from which the packages will be exported.")
        public String[] endpoints();

        @AttributeDefinition(name="Pull Items", description="number of subsequent pull requests to make")
        public int pull_items() default 0x7FFFFFFF;

        @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
        public String packageBuilder_target() default "(name=default)";

        @AttributeDefinition(name="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.")
        public String transportSecretProvider_target() default "(name=default)";
    }
}

