/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.impl;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DefaultDistributor
implements Distributor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DistributionComponentProvider componentProvider;

    @NotNull
    public DistributionResponse distribute(@NotNull String agentName, @NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest) {
        DistributionAgent agent = this.componentProvider.getService(DistributionAgent.class, agentName);
        if (agent == null) {
            return new SimpleDistributionResponse(DistributionRequestState.NOT_EXECUTED, "Agent is not available");
        }
        try {
            return agent.execute(resourceResolver, distributionRequest);
        }
        catch (DistributionException e) {
            this.log.error("cannot execute", (Throwable)e);
            return new SimpleDistributionResponse(DistributionRequestState.DROPPED, "Cannot execute request " + e.getMessage());
        }
    }
}

