/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthException;
import org.apache.sling.auth.oauth_client.impl.OAuthToken;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenStore;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
public class JcrUserHomeOAuthTokenStore
implements OAuthTokenStore {
    private static final String PROPERTY_NAME_EXPIRES_AT = "expires_at";
    private static final String PROPERTY_NAME_REFRESH_TOKEN = "refresh_token";
    private static final Logger logger = LoggerFactory.getLogger(JcrUserHomeOAuthTokenStore.class);
    private final CryptoService cryptoService;

    @Activate
    public JcrUserHomeOAuthTokenStore(@Reference CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Override
    @NotNull
    public OAuthToken getAccessToken(@NotNull ClientConnection connection, @NotNull ResourceResolver resolver) {
        try {
            Calendar expiresCal;
            User user = JcrUserHomeOAuthTokenStore.adaptToUser(resolver);
            Value[] expiresAt = user.getProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            if (expiresAt != null && expiresAt.length == 1 && expiresAt[0].getType() == 5 && (expiresCal = expiresAt[0].getDate()).before(Calendar.getInstance())) {
                logger.info("Token for {} expired at {}, marking as expired", (Object)connection.name(), (Object)expiresCal);
                return new OAuthToken(TokenState.EXPIRED, null);
            }
            return this.getToken(connection, user, "access_token");
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    @NotNull
    private OAuthToken getToken(@NotNull ClientConnection connection, @NotNull User user, @NotNull String propertyName) throws RepositoryException {
        Value[] tokenValue = user.getProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, propertyName));
        if (tokenValue == null) {
            return new OAuthToken(TokenState.MISSING, null);
        }
        if (tokenValue.length != 1) {
            throw new OAuthException(String.format("Unexpected value count %d for token property %s", tokenValue.length, propertyName));
        }
        String encryptedValue = tokenValue[0].getString();
        return new OAuthToken(TokenState.VALID, this.cryptoService.decrypt(encryptedValue));
    }

    @Override
    @NotNull
    public OAuthToken getRefreshToken(@NotNull ClientConnection connection, @NotNull ResourceResolver resolver) {
        try {
            User user = JcrUserHomeOAuthTokenStore.adaptToUser(resolver);
            return this.getToken(connection, user, PROPERTY_NAME_REFRESH_TOKEN);
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    @Override
    public void persistTokens(@NotNull ClientConnection connection, @NotNull ResourceResolver resolver, @NotNull OAuthTokens tokens) {
        try {
            User user = JcrUserHomeOAuthTokenStore.adaptToUser(resolver);
            Session session = JcrUserHomeOAuthTokenStore.adaptToSession(resolver);
            ValueFactory vf = session.getValueFactory();
            this.setTokenProperty(user, vf, JcrUserHomeOAuthTokenStore.propertyPath(connection, "access_token"), tokens.accessToken());
            this.setTokenProperty(user, vf, JcrUserHomeOAuthTokenStore.propertyPath(connection, PROPERTY_NAME_REFRESH_TOKEN), tokens.refreshToken());
            ZonedDateTime expiry = null;
            long expiresAt = tokens.expiresAt();
            if (expiresAt > 0L) {
                expiry = ZonedDateTime.now().plusSeconds(expiresAt);
            }
            if (expiry != null) {
                GregorianCalendar cal = GregorianCalendar.from(expiry);
                user.setProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT), vf.createValue((Calendar)cal));
            } else {
                user.removeProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    @Override
    public void clearAccessToken(@NotNull ClientConnection connection, @NotNull ResourceResolver resolver) throws OAuthException {
        try {
            User currentUser = JcrUserHomeOAuthTokenStore.adaptToUser(resolver);
            currentUser.removeProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, "access_token"));
            currentUser.removeProperty(JcrUserHomeOAuthTokenStore.propertyPath(connection, PROPERTY_NAME_EXPIRES_AT));
            JcrUserHomeOAuthTokenStore.adaptToSession(resolver).save();
        }
        catch (RepositoryException e) {
            throw new OAuthException(e);
        }
    }

    private void setTokenProperty(@NotNull User user, @NotNull ValueFactory valueFactory, @NotNull String propertyPath, @Nullable String value) throws RepositoryException {
        if (value != null) {
            user.setProperty(propertyPath, this.createTokenValue(valueFactory, value));
        } else {
            logger.info("Token value is null, removing property {}", (Object)propertyPath);
            user.removeProperty(propertyPath);
        }
    }

    @NotNull
    private Value createTokenValue(@NotNull ValueFactory valueFactory, @NotNull String propertyValue) {
        String encryptedValue = this.cryptoService.encrypt(propertyValue);
        return valueFactory.createValue(encryptedValue);
    }

    @NotNull
    private static String propertyPath(@NotNull ClientConnection connection, @NotNull String propertyName) {
        return JcrUserHomeOAuthTokenStore.nodePath(connection) + "/" + propertyName;
    }

    @NotNull
    private static String nodePath(@NotNull ClientConnection connection) {
        return "oauth-tokens/" + connection.name();
    }

    @NotNull
    private static User adaptToUser(@NotNull ResourceResolver resolver) {
        User user = (User)resolver.adaptTo(User.class);
        if (user == null) {
            throw new OAuthException("Unable to adapt resolver to a user.");
        }
        return user;
    }

    @NotNull
    private static Session adaptToSession(@NotNull ResourceResolver resolver) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new OAuthException("Unable to adapt resolver to a session.");
        }
        return session;
    }
}

