/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.JakartaAuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.JakartaAuthenticationHandler;

public class AuthenticationHandlerWrapper {
    public static JakartaAuthenticationHandler wrap(AuthenticationHandler handler) {
        if (handler instanceof AuthenticationFeedbackHandler) {
            return new FeedbackHandlerWrapper(handler);
        }
        return new HandlerWrapper(handler);
    }

    private static class FeedbackHandlerWrapper
    extends HandlerWrapper
    implements JakartaAuthenticationFeedbackHandler {
        private final AuthenticationFeedbackHandler handler;

        FeedbackHandlerWrapper(AuthenticationHandler handler) {
            super(handler);
            this.handler = (AuthenticationFeedbackHandler)((Object)handler);
        }

        @Override
        public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
            this.handler.authenticationFailed(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response), authInfo);
        }

        @Override
        public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
            return this.handler.authenticationSucceeded(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response), authInfo);
        }
    }

    private static class HandlerWrapper
    implements JakartaAuthenticationHandler {
        private final AuthenticationHandler handler;

        HandlerWrapper(AuthenticationHandler handler) {
            this.handler = handler;
        }

        @Override
        public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.handler.dropCredentials(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response));
        }

        @Override
        public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
            return this.handler.extractCredentials(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response));
        }

        @Override
        public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return this.handler.requestCredentials(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response));
        }
    }
}

