/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.internalizer;

import com.sun.istack.NotNull;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.internalizer.DOMForestScanner;
import com.sun.tools.xjc.reader.internalizer.Messages;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.xjc.util.DOMUtils;
import com.sun.tools.xjc.util.ForkContentHandler;
import com.sun.xml.xsom.SCD;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSSchemaSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SCDBasedBindingSet {
    private Target topLevel;
    private final DOMForest forest;
    private ErrorReceiver errorReceiver;
    private UnmarshallerHandler unmarshaller;
    private ForkContentHandler loader;

    SCDBasedBindingSet(DOMForest forest) {
        this.forest = forest;
    }

    Target createNewTarget(Target parent, Element src, SCD scd) {
        return new Target(parent, src, scd);
    }

    public void apply(XSSchemaSet schema, ErrorReceiver errorReceiver) {
        if (this.topLevel != null) {
            this.errorReceiver = errorReceiver;
            Unmarshaller u = BindInfo.getCustomizationUnmarshaller();
            this.unmarshaller = u.getUnmarshallerHandler();
            ValidatorHandler v = BindInfo.bindingFileSchema.newValidator();
            v.setErrorHandler(errorReceiver);
            this.loader = new ForkContentHandler(v, (ContentHandler)this.unmarshaller);
            this.topLevel.applyAll(schema.getSchemas());
            this.loader = null;
            this.unmarshaller = null;
            this.errorReceiver = null;
        }
    }

    private void reportError(Element errorSource, String formattedMsg) {
        this.reportError(errorSource, formattedMsg, null);
    }

    private void reportError(Element errorSource, String formattedMsg, Exception nestedException) {
        SAXParseException2 e = new SAXParseException2(formattedMsg, this.forest.locatorTable.getStartLocation(errorSource), nestedException);
        this.errorReceiver.error((SAXParseException)e);
    }

    final class Target {
        private Target firstChild;
        private final Target nextSibling;
        @NotNull
        private final SCD scd;
        @NotNull
        private final Element src;
        private final List<Element> bindings = new ArrayList<Element>();

        private Target(Target parent, Element src, SCD scd) {
            if (parent == null) {
                this.nextSibling = SCDBasedBindingSet.this.topLevel;
                SCDBasedBindingSet.this.topLevel = this;
            } else {
                this.nextSibling = parent.firstChild;
                parent.firstChild = this;
            }
            this.src = src;
            this.scd = scd;
        }

        void addBinidng(Element binding) {
            this.bindings.add(binding);
        }

        private void applyAll(Collection<? extends XSComponent> contextNode) {
            Target self = this;
            while (self != null) {
                self.apply(contextNode);
                self = self.nextSibling;
            }
        }

        private void apply(Collection<? extends XSComponent> contextNode) {
            Collection<XSComponent> childNodes = this.scd.select(contextNode);
            if (childNodes.isEmpty()) {
                if (this.src.getAttributeNode("if-exists") != null) {
                    return;
                }
                SCDBasedBindingSet.this.reportError(this.src, Messages.format("ERR_SCD_EVALUATED_EMPTY", this.scd));
                return;
            }
            if (this.firstChild != null) {
                this.firstChild.applyAll(childNodes);
            }
            if (!this.bindings.isEmpty()) {
                Iterator<XSComponent> itr = childNodes.iterator();
                XSComponent target = itr.next();
                if (itr.hasNext()) {
                    SCDBasedBindingSet.this.reportError(this.src, Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES", this.scd, childNodes.size()));
                    SCDBasedBindingSet.this.errorReceiver.error(target.getLocator(), Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES_FIRST", new Object[0]));
                    SCDBasedBindingSet.this.errorReceiver.error(itr.next().getLocator(), Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES_SECOND", new Object[0]));
                }
                for (Element binding : this.bindings) {
                    for (Element item : DOMUtils.getChildElements(binding)) {
                        String localName = item.getLocalName();
                        if ("bindings".equals(localName)) continue;
                        try {
                            new DOMForestScanner(SCDBasedBindingSet.this.forest).scan(item, (ContentHandler)SCDBasedBindingSet.this.loader);
                            BIDeclaration decl = (BIDeclaration)SCDBasedBindingSet.this.unmarshaller.getResult();
                            XSAnnotation ann = target.getAnnotation(true);
                            BindInfo bi = (BindInfo)ann.getAnnotation();
                            if (bi == null) {
                                bi = new BindInfo();
                                ann.setAnnotation(bi);
                            }
                            bi.addDecl(decl);
                        }
                        catch (SAXException e) {
                        }
                        catch (JAXBException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
        }
    }
}

