/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingManager;

public class ThrottlingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final Logger LOG = LogUtils.getL7dLogger(ThrottlingInterceptor.class);
    final ThrottlingManager manager;

    public ThrottlingInterceptor(String phase, ThrottlingManager manager) {
        super(ThrottlingInterceptor.class.getName() + "-" + phase, phase);
        this.manager = manager;
    }

    public void handleMessage(Message message) throws Fault {
        ThrottleResponse rsp = this.manager.getThrottleResponse(this.getPhase(), message);
        if (rsp == null) {
            return;
        }
        message.getExchange().put(ThrottleResponse.class, (Object)rsp);
        if (rsp.getResponseCode() >= 300) {
            this.createOutMessage(message);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
            return;
        }
        long l = rsp.getDelay();
        if (l > 0L) {
            ContinuationProvider cp = (ContinuationProvider)message.get(ContinuationProvider.class);
            if (cp == null) {
                LOG.warning("No ContinuationProvider available, sleeping on current thread");
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            Continuation c = cp.getContinuation();
            c.suspend(l);
        }
    }

    private Message createOutMessage(Message inMessage) {
        Endpoint e = inMessage.getExchange().getEndpoint();
        Message mout = e.getBinding().createMessage();
        mout.setExchange(inMessage.getExchange());
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)inMessage.getExchange()));
        inMessage.getExchange().setOutMessage(mout);
        inMessage.getExchange().put((Object)"cxf.io.cacheinput", (Object)Boolean.FALSE);
        return mout;
    }
}

