/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.util.ReflectionUtils;

public final class ReflectUtils {
    private static final Field MODIFIERS_FIELD = ReflectionUtils.findField(Field.class, (String)"modifiers");

    private ReflectUtils() {
    }

    public static void setField(Object instance, String fieldName, Object value) {
        ReflectUtils.setField(instance.getClass(), instance, fieldName, value);
    }

    public static void setField(Class<?> cls, Object instance, String fieldName, Object value) {
        Field field = ReflectionUtils.findField(cls, (String)fieldName);
        try {
            if ((field.getModifiers() & 0x10) != 0) {
                MODIFIERS_FIELD.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static Method findMethod(Class<?> cls, String methodName) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static <T> Class<T> getFieldArgument(Class<?> genericCls, String fieldName) {
        try {
            Type generic = FieldUtils.getField(genericCls, (String)fieldName).getGenericType();
            TypeToken token = TypeToken.of(genericCls).resolveType(generic);
            Type fieldType = token.getType();
            Type argument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (argument instanceof GenericArrayType) {
                return TypeToken.of((Type)argument).getRawType();
            }
            return (Class)argument;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to get generic argument.", e);
        }
    }

    public static <T> T constructArrayType(Class<?> cls) {
        return (T)Array.newInstance(cls, 0).getClass();
    }

    static {
        MODIFIERS_FIELD.setAccessible(true);
    }
}

