/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.requestbody.RequestBodyDescriptionRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.RequestBodyValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.MediaTypeValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.RequestBodyValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.requestbody.RequestBodyContentValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultRequestBodyValidatorFactory
implements RequestBodyValidatorFactory {
    private final MediaTypeValidatorFactory mediaTypeValidatorFactory;

    public DefaultRequestBodyValidatorFactory(MediaTypeValidatorFactory mediaTypeValidatorFactory) {
        this.mediaTypeValidatorFactory = mediaTypeValidatorFactory;
    }

    public List<RequestBodyValidator> create(FactoryOptions options) {
        ArrayList<RequestBodyValidator> validators = new ArrayList<RequestBodyValidator>();
        validators.add((RequestBodyValidator)new RequestBodyContentValidator(this.mediaTypeValidatorFactory.create(options)));
        this.addRequestBodyDescriptionRequiredValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addRequestBodyDescriptionRequiredValidator(List<RequestBodyValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("requestBody.description.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new RequestBodyDescriptionRequiredValidator());
        }
    }
}

