/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.ServiceRegistryClientImpl;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.registry.AbstractServiceRegistry;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryTaskInitializer;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import org.apache.servicecomb.serviceregistry.task.event.PeriodicPullEvent;
import org.apache.servicecomb.serviceregistry.task.event.PullMicroserviceVersionsInstancesEvent;
import org.apache.servicecomb.serviceregistry.task.event.ShutdownEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceRegistry.class);
    private ScheduledThreadPoolExecutor taskPool;
    private List<ServiceRegistryTaskInitializer> taskInitializers = SPIServiceUtils.getOrLoadSortedService(ServiceRegistryTaskInitializer.class);

    public RemoteServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        super(eventBus, serviceRegistryConfig, microserviceDefinition);
    }

    @Override
    public void init() {
        super.init();
        this.taskPool = new ScheduledThreadPoolExecutor(3, task -> new Thread(task){

            @Override
            public void run() {
                try {
                    this.setName("Service Center Task [" + task.toString() + "[" + this.getId() + "]]");
                    super.run();
                }
                catch (Throwable e) {
                    LOGGER.error("task {} execute error.", (Object)this.getName(), (Object)e);
                }
            }
        }, (task, executor) -> LOGGER.warn("Too many pending tasks, reject " + task.toString()));
    }

    @Override
    protected ServiceRegistryClient createServiceRegistryClient() {
        return new ServiceRegistryClientImpl(this.ipPortManager);
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        LOGGER.info("service center task is shutdown.");
        this.taskPool.shutdownNow();
    }

    @Override
    public void run() {
        super.run();
        this.taskPool.scheduleAtFixedRate(this.serviceCenterTask, this.serviceRegistryConfig.getHeartbeatInterval(), this.serviceRegistryConfig.getHeartbeatInterval(), TimeUnit.SECONDS);
        this.taskPool.scheduleAtFixedRate(() -> this.eventBus.post((Object)new PeriodicPullEvent()), this.serviceRegistryConfig.getInstancePullInterval(), this.serviceRegistryConfig.getInstancePullInterval(), TimeUnit.SECONDS);
        for (ServiceRegistryTaskInitializer initializer : this.taskInitializers) {
            initializer.init(this);
        }
    }

    @Subscribe
    public void onPullMicroserviceVersionsInstancesEvent(PullMicroserviceVersionsInstancesEvent event) {
        this.taskPool.schedule(event.getMicroserviceVersions()::pullInstances, event.getMsDelay(), TimeUnit.MILLISECONDS);
    }

    @Subscribe
    public void onMicroserviceHeartbeatTask(MicroserviceInstanceHeartbeatTask event) {
        if (HeartbeatResult.SUCCESS.equals((Object)event.getHeartbeatResult())) {
            this.ipPortManager.initAutoDiscovery();
        }
    }

    public ScheduledThreadPoolExecutor getTaskPool() {
        return this.taskPool;
    }
}

