/*
 * Decompiled with CFR 0.152.
 */
package brave.servlet;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.servlet.HttpServletAdapter;
import brave.servlet.ServletRuntime;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class TracingFilter
implements Filter {
    static final Propagation.Getter<HttpServletRequest, String> GETTER = new Propagation.Getter<HttpServletRequest, String>(){

        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }

        public String toString() {
            return "HttpServletRequest::getHeader";
        }
    };
    static final HttpServletAdapter ADAPTER = new HttpServletAdapter();
    final ServletRuntime servlet = ServletRuntime.get();
    final CurrentTraceContext currentTraceContext;
    final Tracer tracer;
    final HttpServerHandler<HttpServletRequest, HttpServletResponse> handler;
    final TraceContext.Extractor<HttpServletRequest> extractor;

    public static Filter create(Tracing tracing) {
        return new TracingFilter(HttpTracing.create((Tracing)tracing));
    }

    public static Filter create(HttpTracing httpTracing) {
        return new TracingFilter(httpTracing);
    }

    TracingFilter(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)ADAPTER);
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = this.servlet.httpResponse(response);
        TraceContext context = (TraceContext)request.getAttribute(TraceContext.class.getName());
        if (context != null) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(context);
            try {
                chain.doFilter(request, response);
            }
            finally {
                scope.close();
            }
            return;
        }
        Span span = this.handler.handleReceive(this.extractor, (Object)httpRequest);
        request.setAttribute(SpanCustomizer.class.getName(), (Object)span.customizer());
        request.setAttribute(TraceContext.class.getName(), (Object)span.context());
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (IOException | Error | RuntimeException | ServletException e) {
            error = e;
            throw e;
        }
        finally {
            scope.close();
            if (this.servlet.isAsync(httpRequest)) {
                this.servlet.handleAsync(this.handler, httpRequest, httpResponse, span);
            } else {
                this.handler.handleSend((Object)ADAPTER.adaptResponse(httpRequest, httpResponse), error, span);
            }
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }
}

